/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.hierarchy.IChildrenProvider;
import com.helger.commons.hierarchy.IHasParent;
import com.helger.commons.hierarchy.IParentProvider;
import com.helger.commons.id.IHasID;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.tree.withid.DefaultTreeWithID;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWithIDBuilder {
    private static final TreeWithIDBuilder s_aInstance = new TreeWithIDBuilder();

    private TreeWithIDBuilder() {
    }

    @Nonnull
    private static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, DATATYPE> _buildTree(@Nonnull List<DATATYPE> list, @Nonnull IParentProvider<DATATYPE> iParentProvider) {
        DefaultTreeWithID defaultTreeWithID = new DefaultTreeWithID();
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        int n = 0;
        while (!list.isEmpty()) {
            Object object;
            IHasID iHasID = (IHasID)list.remove(0);
            IHasID iHasID2 = iParentProvider.getParent(iHasID);
            Object IDTYPE = iHasID.getID();
            if (iHasID2 == null) {
                object = (DefaultTreeItemWithID)((DefaultTreeItemWithID)defaultTreeWithID.getRootItem()).createChildItem(IDTYPE, iHasID);
                commonsHashMap.put(IDTYPE, object);
                n = 0;
                continue;
            }
            object = iHasID2.getID();
            if (commonsHashMap.containsKey(object)) {
                DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)commonsHashMap.get(object);
                DefaultTreeItemWithID defaultTreeItemWithID2 = (DefaultTreeItemWithID)defaultTreeItemWithID.createChildItem(IDTYPE, iHasID);
                commonsHashMap.put(IDTYPE, defaultTreeItemWithID2);
                n = 0;
                continue;
            }
            list.add(iHasID);
            if (++n != list.size()) continue;
            throw new IllegalStateException("The hierarchy is illegal. It contains elements that fit nowhere in the tree: " + list);
        }
        return defaultTreeWithID;
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, DATATYPE> buildTree(@Nonnull Collection<? extends DATATYPE> collection, @Nonnull IParentProvider<DATATYPE> iParentProvider) {
        ValueEnforcer.notNull(collection, "All");
        ValueEnforcer.notNull(iParentProvider, "ParentResolver");
        return TreeWithIDBuilder._buildTree(new CommonsArrayList<Collection<? extends DATATYPE>>(collection), iParentProvider);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, DATATYPE> buildTree(@Nonnull DATATYPE[] DATATYPEArray, @Nonnull IParentProvider<DATATYPE> iParentProvider) {
        ValueEnforcer.notNull(DATATYPEArray, "All");
        ValueEnforcer.notNull(iParentProvider, "ParentResolver");
        return TreeWithIDBuilder._buildTree(new CommonsArrayList<DATATYPE>(DATATYPEArray), iParentProvider);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE extends IHasParent<DATATYPE> & IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, DATATYPE> buildTree(@Nonnull Collection<? extends DATATYPE> collection) {
        ValueEnforcer.notNull(collection, "All");
        return TreeWithIDBuilder.buildTree(collection, IParentProvider.parentProviderHasParent());
    }

    private static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> void _buildTreeRecursive(@Nullable DefaultTreeItemWithID<KEYTYPE, DATATYPE> defaultTreeItemWithID, @Nonnull IChildrenProvider<DATATYPE> iChildrenProvider) {
        IHasID iHasID;
        if (defaultTreeItemWithID != null && iChildrenProvider.hasChildren(iHasID = (IHasID)defaultTreeItemWithID.getData())) {
            for (IHasID iHasID2 : iChildrenProvider.getAllChildren(iHasID)) {
                DefaultTreeItemWithID defaultTreeItemWithID2 = (DefaultTreeItemWithID)defaultTreeItemWithID.createChildItem(iHasID2.getID(), iHasID2);
                TreeWithIDBuilder._buildTreeRecursive(defaultTreeItemWithID2, iChildrenProvider);
            }
        }
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> DefaultTreeWithID<KEYTYPE, DATATYPE> buildTree(@Nonnull IChildrenProvider<DATATYPE> iChildrenProvider) {
        ValueEnforcer.notNull(iChildrenProvider, "ChildrenResolver");
        DefaultTreeWithID defaultTreeWithID = new DefaultTreeWithID();
        if (iChildrenProvider.hasChildren(null)) {
            for (IHasID iHasID : iChildrenProvider.getAllChildren(null)) {
                DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)((DefaultTreeItemWithID)defaultTreeWithID.getRootItem()).createChildItem(iHasID.getID(), iHasID);
                TreeWithIDBuilder._buildTreeRecursive(defaultTreeItemWithID, iChildrenProvider);
            }
        }
        return defaultTreeWithID;
    }
}

