/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.util;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.tree.IBasicTree;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.ITreeItemWithID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWithIDSearcher {
    private static final TreeWithIDSearcher s_aInstance = new TreeWithIDSearcher();

    private TreeWithIDSearcher() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> ICommonsList<ITEMTYPE> findAllItemsWithIDRecursive(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nullable KEYTYPE KEYTYPE) {
        return TreeWithIDSearcher.findAllItemsWithIDRecursive((ITreeItemWithID)iBasicTree.getRootItem(), KEYTYPE);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> ICommonsList<ITEMTYPE> findAllItemsWithIDRecursive(@Nonnull ITEMTYPE ITEMTYPE, final @Nullable KEYTYPE KEYTYPE) {
        final CommonsArrayList commonsArrayList = new CommonsArrayList();
        TreeVisitor.visitTreeItem(ITEMTYPE, new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            @Override
            @Nonnull
            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null && ITEMTYPE.getID().equals(KEYTYPE)) {
                    commonsArrayList.add(ITEMTYPE);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
        return commonsArrayList;
    }
}

