/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.withid.unique;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tree.IBasicTreeItem;
import com.helger.tree.withid.ITreeItemWithID;
import com.helger.tree.withid.unique.ITreeItemWithUniqueIDFactory;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractTreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>>
implements ITreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> {
    private final ICommonsMap<KEYTYPE, ITEMTYPE> m_aItemStore;

    public AbstractTreeItemWithUniqueIDFactory() {
        this(new CommonsHashMap());
    }

    public AbstractTreeItemWithUniqueIDFactory(@Nonnull ICommonsMap<KEYTYPE, ITEMTYPE> iCommonsMap) {
        this.m_aItemStore = ValueEnforcer.notNull(iCommonsMap, "ItemStore");
    }

    @Nonnull
    protected final ITEMTYPE addToItemStore(@Nonnull KEYTYPE KEYTYPE, @Nonnull ITEMTYPE ITEMTYPE) {
        if (this.m_aItemStore.containsKey(KEYTYPE)) {
            throw new IllegalArgumentException("An item with ID '" + KEYTYPE + "' is already contained!");
        }
        this.m_aItemStore.put(KEYTYPE, ITEMTYPE);
        return ITEMTYPE;
    }

    @Nonnull
    protected abstract ITEMTYPE internalCreate(@Nonnull ITEMTYPE var1, @Nonnull KEYTYPE var2);

    @Nonnull
    @OverrideOnDemand
    protected KEYTYPE internalGetItemID(@Nonnull ITEMTYPE ITEMTYPE) {
        return ITEMTYPE.getID();
    }

    @Override
    @Nonnull
    public final ITEMTYPE create(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull KEYTYPE KEYTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "Parent");
        ITEMTYPE ITEMTYPE2 = this.internalCreate(ITEMTYPE, KEYTYPE);
        return this.addToItemStore(this.internalGetItemID(ITEMTYPE2), ITEMTYPE2);
    }

    @Override
    public final void onRemoveItem(@Nonnull ITEMTYPE ITEMTYPE) {
        this.m_aItemStore.remove(this.internalGetItemID(ITEMTYPE));
    }

    @Override
    public final void onAddItem(@Nonnull ITEMTYPE ITEMTYPE) {
        this.addToItemStore(this.internalGetItemID(ITEMTYPE), ITEMTYPE);
    }

    @Override
    public final boolean containsItemWithDataID(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aItemStore.containsKey(KEYTYPE);
    }

    @Override
    @Nullable
    public final ITEMTYPE getItemOfDataID(@Nullable KEYTYPE KEYTYPE) {
        return (ITEMTYPE)((ITreeItemWithID)this.m_aItemStore.get(KEYTYPE));
    }

    @Override
    @Nonnegative
    public final int getItemCount() {
        return this.m_aItemStore.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ITEMTYPE> getAllItems() {
        return this.m_aItemStore.copyOfValues();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<DATATYPE> getAllItemDatas() {
        return this.m_aItemStore.copyOfValuesMapped(IBasicTreeItem::getData);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractTreeItemWithUniqueIDFactory abstractTreeItemWithUniqueIDFactory = (AbstractTreeItemWithUniqueIDFactory)object;
        return this.m_aItemStore.equals(abstractTreeItemWithUniqueIDFactory.m_aItemStore);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aItemStore)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("itemStoreKeys", this.m_aItemStore.keySet()).getToString();
    }
}

