/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl21;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.ubl21.EUBL21DocumentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class UBL21DocumentTypes {
    private static final ICommonsMap<String, EUBL21DocumentType> s_aNamespace2DocType = new CommonsHashMap<String, EUBL21DocumentType>();
    private static final ICommonsMap<String, EUBL21DocumentType> s_aLocalName2DocType = new CommonsHashMap<String, EUBL21DocumentType>();
    private static final UBL21DocumentTypes s_aInstance;

    private UBL21DocumentTypes() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllNamespaces() {
        return s_aNamespace2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBL21DocumentType getDocumentTypeOfNamespace(@Nullable String string) {
        return (EUBL21DocumentType)s_aNamespace2DocType.get(string);
    }

    @Nullable
    public static Class<?> getImplementationClassOfNamespace(@Nullable String string) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getImplementationClass();
    }

    @Nullable
    public static EUBL21DocumentType getDocumentTypeOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ArrayHelper.findFirst(EUBL21DocumentType.values(), eUBL21DocumentType -> eUBL21DocumentType.getImplementationClass().equals(clazz));
    }

    @Nullable
    public static Schema getSchemaOfNamespace(@Nullable String string) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getSchema();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllLocalNames() {
        return s_aLocalName2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBL21DocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return (EUBL21DocumentType)s_aLocalName2DocType.get(string);
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getImplementationClass();
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        EUBL21DocumentType eUBL21DocumentType = UBL21DocumentTypes.getDocumentTypeOfImplementationClass(clazz);
        return eUBL21DocumentType == null ? null : eUBL21DocumentType.getSchema();
    }

    static {
        for (EUBL21DocumentType eUBL21DocumentType : EUBL21DocumentType.values()) {
            String string = eUBL21DocumentType.getNamespaceURI();
            if (s_aNamespace2DocType.containsKey(string)) {
                throw new IllegalArgumentException("The namespace '" + string + "' is already mapped!");
            }
            s_aNamespace2DocType.put(string, eUBL21DocumentType);
            String string2 = eUBL21DocumentType.getLocalName();
            if (s_aLocalName2DocType.containsKey(string2)) {
                throw new IllegalArgumentException("The local name '" + string2 + "' is already mapped!");
            }
            s_aLocalName2DocType.put(string2, eUBL21DocumentType);
        }
        s_aInstance = new UBL21DocumentTypes();
    }
}

