/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.uaprofile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.url.URLHelper;
import com.helger.useragent.uaprofile.IUAProfileHeaderProvider;
import com.helger.useragent.uaprofile.UAProfile;
import com.helger.useragent.uaprofile.UAProfileDiff;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UAProfileDatabase {
    public static final int EXPECTED_MD5_DIGEST_LENGTH = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(UAProfileDatabase.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsSet<UAProfile> s_aUniqueUAProfiles = new CommonsHashSet<UAProfile>();
    @GuardedBy(value="s_aRWLock")
    private static Consumer<UAProfile> s_aNewUAProfileCallback;
    private static final UAProfileDatabase s_aInstance;

    private UAProfileDatabase() {
    }

    @Nullable
    public static Consumer<UAProfile> getNewUAProfileCallback() {
        return s_aRWLock.readLockedGet(() -> s_aNewUAProfileCallback);
    }

    public static void setNewUAProfileCallback(@Nullable Consumer<UAProfile> consumer) {
        s_aRWLock.writeLockedGet(() -> {
            s_aNewUAProfileCallback = consumer;
            return s_aNewUAProfileCallback;
        });
    }

    @Nullable
    private static String _getExtendedNamespaceValue(@Nonnull String string) {
        Matcher matcher = RegExHelper.getMatcher(".+ns=(\\d+).*", string);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Nonnull
    private static String _getUnifiedHeaderName(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    @Nullable
    private static String _getCleanedUp(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string2 = string.trim();
        if (StringHelper.getFirstChar(string2) == '\"') {
            string2 = string2.substring(1);
        }
        if (StringHelper.getLastChar(string2) == '\"') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Nonnull
    private static ICommonsMap<Integer, String> _getProfileDiffData(@Nonnull IUAProfileHeaderProvider iUAProfileHeaderProvider, String string) {
        ICommonsCollection<String> iCommonsCollection = iUAProfileHeaderProvider.getHeaders("X-Wap-Profile-Diff");
        if (iCommonsCollection.isEmpty() && (iCommonsCollection = iUAProfileHeaderProvider.getHeaders("Profile-Diff")).isEmpty()) {
            iCommonsCollection = iUAProfileHeaderProvider.getHeaders("Wap-Profile-Diff");
        }
        CommonsHashMap<Integer, String> commonsHashMap = new CommonsHashMap<Integer, String>();
        for (String string2 : iCommonsCollection) {
            String string3 = string2.trim();
            int n = string3.indexOf(59);
            if (n == -1) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Failed to find ';' in profile diff header value '" + string3 + "'!");
                continue;
            }
            String string4 = string3.substring(0, n);
            int n2 = StringParser.parseInt(string4, -1);
            if (n2 == -1) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Failed to convert UAProf difference index '" + string4 + "' to a number!");
                continue;
            }
            String string5 = string3.substring(n + 1).trim();
            commonsHashMap.put(n2, string5);
        }
        if (commonsHashMap.isEmpty() && string != null) {
            String string3 = UAProfileDatabase._getUnifiedHeaderName(string + "-Profile-Diff-");
            for (String string6 : iUAProfileHeaderProvider.getAllHeaderNames()) {
                if (!(string6 = UAProfileDatabase._getUnifiedHeaderName(string6)).startsWith(string3)) continue;
                int n = StringParser.parseInt(string6.substring(string3.length()), -1);
                if (n != -1) {
                    String string7 = iUAProfileHeaderProvider.getHeaderValue(string6);
                    string7 = UAProfileDatabase._getCleanedUp(string7);
                    commonsHashMap.put(n, string7);
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Failed to extract numerical number from header name '" + string6 + "'");
            }
        }
        return commonsHashMap;
    }

    @Nullable
    public static UAProfile getUAProfileFromRequest(@Nonnull IUAProfileHeaderProvider iUAProfileHeaderProvider) {
        Object object;
        Object object2;
        Object object4;
        ValueEnforcer.notNull(iUAProfileHeaderProvider, "HeaderProvider");
        String string = null;
        ICommonsCollection<String> iCommonsCollection = iUAProfileHeaderProvider.getHeaders("X-Wap-Profile");
        if (iCommonsCollection.isEmpty() && (iCommonsCollection = iUAProfileHeaderProvider.getHeaders("Profile")).isEmpty() && (iCommonsCollection = iUAProfileHeaderProvider.getHeaders("Wap-Profile")).isEmpty()) {
            object4 = iUAProfileHeaderProvider.getHeaderValue("Opt");
            if (object4 == null) {
                object4 = iUAProfileHeaderProvider.getHeaderValue("Man");
            }
            if (object4 != null) {
                string = UAProfileDatabase._getExtendedNamespaceValue((String)object4);
                if (string != null) {
                    iCommonsCollection = iUAProfileHeaderProvider.getHeaders(string + "-Profile");
                    if (iCommonsCollection.isEmpty() && LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Found CCPP header namespace '" + string + "' but found no profile header!");
                    }
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Failed to extract namespace value from CCPP header '" + (String)object4 + "'");
                }
            }
        }
        object4 = new CommonsArrayList();
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (String string2 : iCommonsCollection) {
            String object32 = UAProfileDatabase._getCleanedUp(string2);
            if (!StringHelper.hasText(object32)) continue;
            Iterator iterator = new StringTokenizer(object32, "\",");
            while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                String string3 = ((StringTokenizer)((Object)iterator)).nextToken().trim();
                if (!StringHelper.hasText(string3)) continue;
                object2 = RegExHelper.getMatcher("^(\\d+)-(.+)$", string3);
                if (((Matcher)object2).matches()) {
                    object = ((Matcher)object2).group(1);
                    String string4 = ((Matcher)object2).group(2);
                    int n = StringParser.parseInt((String)object, -1);
                    if (n != -1) {
                        if (StringHelper.hasText(string4)) {
                            byte[] byArray = Base64.safeDecode(string4);
                            if (byArray != null) {
                                if (byArray.length == 16) {
                                    commonsHashMap.put(n, byArray);
                                    continue;
                                }
                                if (!LOGGER.isWarnEnabled()) continue;
                                LOGGER.warn("Decoded Base64 profile diff digest has an illegal length of " + byArray.length);
                                continue;
                            }
                            if (!LOGGER.isWarnEnabled()) continue;
                            LOGGER.warn("Failed to decode Base64 profile diff digest '" + string4 + "' from token '" + string3 + "'");
                            continue;
                        }
                        if (!LOGGER.isWarnEnabled()) continue;
                        LOGGER.warn("Found no diff digest in token '" + string3 + "'");
                        continue;
                    }
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("Failed to parse profile diff index from '" + string3 + "'");
                    continue;
                }
                if (URLHelper.getAsURL(string3) != null) {
                    object4.add(string3);
                    continue;
                }
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("Failed to convert profile token '" + string3 + "' to a URL!");
            }
        }
        if (object4.isEmpty() && commonsHashMap.isEmpty()) {
            return null;
        }
        ICommonsMap<Integer, String> iCommonsMap = UAProfileDatabase._getProfileDiffData(iUAProfileHeaderProvider, string);
        CommonsHashMap<Integer, UAProfileDiff> commonsHashMap2 = new CommonsHashMap<Integer, UAProfileDiff>();
        for (Map.Entry entry : iCommonsMap.entrySet()) {
            object2 = (Integer)entry.getKey();
            object = (byte[])commonsHashMap.get(object2);
            if (object != null) {
                commonsHashMap2.put(object2, new UAProfileDiff((String)entry.getValue(), (byte[])object));
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("Found profile diff data but no digest for index " + object2);
        }
        for (Integer n : commonsHashMap.keySet()) {
            if (iCommonsMap.containsKey(n) || !LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("Found profile diff digest but no data for index " + n);
        }
        if (object4.isEmpty() && commonsHashMap2.isEmpty()) {
            return null;
        }
        return new UAProfile((List<String>)object4, commonsHashMap2);
    }

    @Nonnull
    public static UAProfile getParsedUAProfile(@Nonnull IUAProfileHeaderProvider iUAProfileHeaderProvider) {
        boolean bl;
        UAProfile uAProfile = UAProfileDatabase.getUAProfileFromRequest(iUAProfileHeaderProvider);
        if (uAProfile == null) {
            return UAProfile.EMPTY;
        }
        if (uAProfile.isSet() && (bl = s_aRWLock.writeLockedBoolean(() -> s_aUniqueUAProfiles.add(uAProfile)))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found UA-Profile info: " + uAProfile.toString());
            }
            if (s_aNewUAProfileCallback != null) {
                s_aNewUAProfileCallback.accept(uAProfile);
            }
        }
        return uAProfile;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<UAProfile> getAllUniqueUAProfiles() {
        return s_aRWLock.readLockedGet(s_aUniqueUAProfiles::getClone);
    }

    static {
        s_aInstance = new UAProfileDatabase();
    }
}

