/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.ICloseable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class AbstractLimitedInputStream
extends FilterInputStream
implements ICloseable {
    private final long m_nSizeMax;
    private long m_nCount;
    private boolean m_bClosed;

    public AbstractLimitedInputStream(@Nonnull InputStream inputStream, @Nonnegative long l) {
        super(inputStream);
        this.m_nSizeMax = ValueEnforcer.isGE0(l, "SizeMax");
    }

    protected abstract void onLimitExceeded(@Nonnegative long var1, @Nonnegative long var3) throws IOException;

    private void _checkLimit() throws IOException {
        if (this.m_nCount > this.m_nSizeMax) {
            this.onLimitExceeded(this.m_nSizeMax, this.m_nCount);
        }
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.m_nCount;
            this._checkLimit();
        }
        return n;
    }

    @Override
    public int read(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.m_nCount += (long)n3;
            this._checkLimit();
        }
        return n3;
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.m_bClosed;
    }

    @Override
    public void close() throws IOException {
        this.m_bClosed = true;
        super.close();
    }
}

