/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.attr.IAttributeContainerAny;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.request.RequestHelper;
import com.helger.web.fileupload.IFileItem;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IRequestParamContainer
extends IAttributeContainerAny<String> {
    @Nonnull
    default public ICommonsMap<String, IFileItem> getAllUploadedFileItems() {
        CommonsHashMap<String, IFileItem> commonsHashMap = new CommonsHashMap<String, IFileItem>();
        for (Map.Entry entry : this.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof IFileItem)) continue;
            commonsHashMap.put(entry.getKey(), (IFileItem)v);
        }
        return commonsHashMap;
    }

    @Nonnull
    default public ICommonsMap<String, IFileItem[]> getAllUploadedFileItemsComplete() {
        CommonsHashMap<String, IFileItem[]> commonsHashMap = new CommonsHashMap<String, IFileItem[]>();
        for (Map.Entry entry : this.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof IFileItem) {
                commonsHashMap.put(string, new IFileItem[]{(IFileItem)v});
                continue;
            }
            if (!(v instanceof IFileItem[])) continue;
            commonsHashMap.put(string, ArrayHelper.getCopy((IFileItem[])v));
        }
        return commonsHashMap;
    }

    @Nonnull
    default public ICommonsList<IFileItem> getAllUploadedFileItemValues() {
        CommonsArrayList<IFileItem> commonsArrayList = new CommonsArrayList<IFileItem>();
        for (Object v : this.values()) {
            if (v instanceof IFileItem) {
                commonsArrayList.add((IFileItem)v);
                continue;
            }
            if (!(v instanceof IFileItem[])) continue;
            Collections.addAll(commonsArrayList, (IFileItem[])v);
        }
        return commonsArrayList;
    }

    @Nullable
    default public IFileItem getAsFileItem(@Nullable String string) {
        return this.getSafeCastedValue(string, IFileItem.class);
    }

    default public boolean isCheckBoxChecked(@Nullable String string, boolean bl) {
        if (StringHelper.hasText(string)) {
            String string2 = this.getAsString(string);
            if (string2 != null) {
                return true;
            }
            if (this.containsKey(RequestHelper.getCheckBoxHiddenFieldName(string))) {
                return false;
            }
        }
        return bl;
    }

    default public boolean hasCheckBoxValue(@Nonnull @Nonempty String string, @Nonnull String string2, boolean bl) {
        ValueEnforcer.notEmpty(string, "FieldName");
        ValueEnforcer.notNull(string2, "FieldValue");
        ICommonsOrderedSet<String> iCommonsOrderedSet = this.getAsStringSet(string);
        if (iCommonsOrderedSet != null) {
            return iCommonsOrderedSet.contains(string2);
        }
        iCommonsOrderedSet = this.getAsStringSet(RequestHelper.getCheckBoxHiddenFieldName(string));
        if (iCommonsOrderedSet != null && iCommonsOrderedSet.contains(string2)) {
            return false;
        }
        return bl;
    }

    @Nullable
    default public String getAsStringTrimmed(@Nullable String string) {
        return StringHelper.trim(this.getAsString(string));
    }

    @Nullable
    default public String getAsStringTrimmed(@Nullable String string, @Nullable String string2) {
        return StringHelper.trim(this.getAsString(string, string2));
    }
}

