/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.scope.GlobalScope;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.web.scope.IGlobalWebScope;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletContext;

@ThreadSafe
public class GlobalWebScope
extends GlobalScope
implements IGlobalWebScope {
    private static final long serialVersionUID = 15665138713664L;
    private final LocalDateTime m_aCreationDT = PDTFactory.getCurrentLocalDateTime();
    private final transient ServletContext m_aSC;

    @Nonnull
    @Nonempty
    private static String _createScopeID(@Nonnull ServletContext servletContext) {
        ValueEnforcer.notNull(servletContext, "ServletContext");
        String string = servletContext.getServletContextName();
        if (string == null) {
            string = "ph-global-web-scope";
        }
        return string;
    }

    public GlobalWebScope(@Nonnull ServletContext servletContext) {
        super(GlobalWebScope._createScopeID(servletContext));
        this.m_aSC = servletContext;
        ServletContextPathHolder.setServletContextPath(servletContext.getContextPath());
    }

    @Override
    @Nonnull
    public final LocalDateTime getCreationDateTime() {
        return this.m_aCreationDT;
    }

    @Override
    protected void postDestroy() {
        super.postDestroy();
        ServletContextPathHolder.clearContextPath();
    }

    @Override
    @Nonnull
    public final ServletContext getServletContext() {
        return this.m_aSC;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        GlobalWebScope globalWebScope = (GlobalWebScope)object;
        return this.m_aSC.getContextPath().equals(globalWebScope.getServletContext().getContextPath());
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aSC.getContextPath()).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("ServletContext", this.m_aSC).getToString();
    }
}

