/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mock;

import com.helger.commons.cleanup.CommonsCleanup;
import com.helger.commons.http.EHttpMethod;
import com.helger.scope.ScopeCleanup;
import com.helger.servlet.mock.MockHttpServletRequest;
import com.helger.servlet.mock.MockServletContext;
import com.helger.xml.util.XMLCleanup;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class WebScopeAwareTestSetup {
    public static final String MOCK_CONTEXT_PATH = "/MockContext";
    private static final WebScopeAwareTestSetup s_aInstance = new WebScopeAwareTestSetup();

    private WebScopeAwareTestSetup() {
    }

    @Nonnull
    public static MockServletContext createDefaultMockServletContext() {
        return WebScopeAwareTestSetup.createDefaultMockServletContext(MOCK_CONTEXT_PATH, null);
    }

    @Nonnull
    public static MockServletContext createDefaultMockServletContext(@Nullable String string, @Nullable Map<String, String> map) {
        return MockServletContext.create(string, map);
    }

    @Nonnull
    public static MockHttpServletRequest createDefaultMockRequest(@Nonnull MockServletContext mockServletContext) {
        return new MockHttpServletRequest(mockServletContext, EHttpMethod.GET);
    }

    public static void shutdownWebScopeTests(@Nullable MockHttpServletRequest mockHttpServletRequest, @Nullable MockServletContext mockServletContext) {
        if (mockHttpServletRequest != null) {
            mockHttpServletRequest.invalidate();
        }
        if (mockServletContext != null) {
            mockServletContext.invalidate();
        }
        XMLCleanup.cleanup();
        ScopeCleanup.cleanup();
        CommonsCleanup.cleanup();
    }
}

