/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.util;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.state.ESuccess;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.JobDataMap;
import com.helger.schedule.job.AbstractJob;
import com.helger.servlet.mock.MockHttpServletRequest;
import com.helger.servlet.mock.MockHttpServletResponse;
import com.helger.servlet.mock.OfflineHttpServletRequest;
import com.helger.web.scope.mgr.WebScopeManager;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractScopeAwareJob
extends AbstractJob {
    @Nonnull
    @OverrideOnDemand
    protected MockHttpServletRequest createMockHttpServletRequest() {
        OfflineHttpServletRequest offlineHttpServletRequest = new OfflineHttpServletRequest(WebScopeManager.getGlobalScope().getServletContext(), false);
        offlineHttpServletRequest.setSessionID("quartz.job." + ClassHelper.getClassLocalName(this.getClass()));
        return offlineHttpServletRequest;
    }

    @Nonnull
    @OverrideOnDemand
    protected MockHttpServletResponse createMockHttpServletResponse() {
        return new MockHttpServletResponse();
    }

    @OverrideOnDemand
    protected void beforeExecuteInScope(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) {
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void beforeExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) {
        MockHttpServletRequest mockHttpServletRequest = this.createMockHttpServletRequest();
        MockHttpServletResponse mockHttpServletResponse = this.createMockHttpServletResponse();
        WebScopeManager.onRequestBegin(mockHttpServletRequest, mockHttpServletResponse);
        this.beforeExecuteInScope(jobDataMap, iJobExecutionContext);
    }

    @OverrideOnDemand
    protected void afterExecuteInScope(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext, @Nonnull ESuccess eSuccess) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void afterExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext, @Nonnull ESuccess eSuccess) {
        try {
            this.afterExecuteInScope(jobDataMap, iJobExecutionContext, eSuccess);
        }
        finally {
            WebScopeManager.onRequestEnd();
        }
    }
}

