/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.microdom.IMicroAttribute;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MicroAttribute
implements IMicroAttribute {
    private final IMicroQName m_aQName;
    private String m_sAttributeValue;

    public MicroAttribute(@Nonnull @Nonempty String string, @Nonnull String string2) {
        this(null, string, string2);
    }

    public MicroAttribute(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull String string3) {
        this(new MicroQName(string, string2), string3);
    }

    public MicroAttribute(@Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        this.m_aQName = ValueEnforcer.notNull(iMicroQName, "QName");
        this.m_sAttributeValue = ValueEnforcer.notNull(string, "AttributeValue");
    }

    @Override
    @Nonnull
    public IMicroQName getAttributeQName() {
        return this.m_aQName;
    }

    @Override
    @Nonnull
    public String getAttributeValue() {
        return this.m_sAttributeValue;
    }

    @Override
    @Nonnull
    public EChange setAttributeValue(@Nonnull String string) {
        ValueEnforcer.notNull(string, "AttributeValue");
        if (string.equals(this.m_sAttributeValue)) {
            return EChange.UNCHANGED;
        }
        this.m_sAttributeValue = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public MicroAttribute getClone() {
        return new MicroAttribute(this.m_aQName, this.m_sAttributeValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MicroAttribute microAttribute = (MicroAttribute)object;
        return this.m_aQName.equals(microAttribute.m_aQName) && this.m_sAttributeValue.equals(microAttribute.m_sAttributeValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aQName).append(this.m_sAttributeValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("QName", this.m_aQName).append("AttributeValue", this.m_sAttributeValue).getToString();
    }
}

