/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MimeTypeInfo {
    private final ICommonsOrderedSet<MimeTypeWithSource> m_aMimeTypes;
    private final String m_sComment;
    private final ICommonsOrderedSet<String> m_aParentTypes;
    private final ICommonsOrderedSet<String> m_aGlobs;
    private final ICommonsOrderedSet<ExtensionWithSource> m_aExtensions;
    private final String m_sSource;

    public MimeTypeInfo(@Nonnull @Nonempty ICommonsOrderedSet<MimeTypeWithSource> iCommonsOrderedSet, @Nullable String string, @Nonnull ICommonsOrderedSet<String> iCommonsOrderedSet2, @Nonnull ICommonsOrderedSet<String> iCommonsOrderedSet3, @Nonnull ICommonsOrderedSet<ExtensionWithSource> iCommonsOrderedSet4, @Nullable String string2) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsOrderedSet, "MimeTypes");
        ValueEnforcer.notNull(iCommonsOrderedSet2, "ParentTypes");
        ValueEnforcer.notNull(iCommonsOrderedSet3, "Globs");
        ValueEnforcer.notNull(iCommonsOrderedSet4, "Extensions");
        this.m_aMimeTypes = iCommonsOrderedSet.getClone();
        this.m_sComment = string;
        this.m_aParentTypes = iCommonsOrderedSet2.getClone();
        this.m_aGlobs = iCommonsOrderedSet3.getClone();
        this.m_aExtensions = iCommonsOrderedSet4.getClone();
        this.m_sSource = string2;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsSet<MimeTypeWithSource> getAllMimeTypesWithSource() {
        return this.m_aMimeTypes.getClone();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsSet<IMimeType> getAllMimeTypes() {
        return this.m_aMimeTypes.getAllMapped(MimeTypeWithSource::getMimeType);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllMimeTypeStrings() {
        return this.m_aMimeTypes.getAllMapped(MimeTypeWithSource::getMimeTypeAsString);
    }

    public boolean containsMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType != null) {
            for (MimeTypeWithSource mimeTypeWithSource : this.m_aMimeTypes) {
                if (!mimeTypeWithSource.getMimeType().equals(iMimeType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsMimeType(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (MimeTypeWithSource mimeTypeWithSource : this.m_aMimeTypes) {
                if (!mimeTypeWithSource.getMimeTypeAsString().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public MimeTypeWithSource getPrimaryMimeTypeWithSource() {
        return this.m_aMimeTypes.getFirst();
    }

    @Nonnull
    public IMimeType getPrimaryMimeType() {
        return this.getPrimaryMimeTypeWithSource().getMimeType();
    }

    @Nonnull
    public String getPrimaryMimeTypeString() {
        return this.getPrimaryMimeTypeWithSource().getMimeTypeAsString();
    }

    @Nullable
    public String getComment() {
        return this.m_sComment;
    }

    public boolean hasComment() {
        return StringHelper.hasText(this.m_sComment);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllParentTypes() {
        return this.m_aParentTypes.getClone();
    }

    public boolean hasAnyParentType() {
        return !this.m_aParentTypes.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllGlobs() {
        return this.m_aGlobs.getClone();
    }

    @Nullable
    public String getPrimaryGlob() {
        return this.m_aGlobs.getFirst();
    }

    public boolean hasAnyGlob() {
        return this.m_aGlobs.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ExtensionWithSource> getAllExtensionsWithSource() {
        return this.m_aExtensions.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllExtensions() {
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        commonsLinkedHashSet.addAllMapped(this.m_aExtensions, ExtensionWithSource::getExtension);
        return commonsLinkedHashSet;
    }

    @Nullable
    public ExtensionWithSource getPrimaryExtensionWithSource() {
        return this.m_aExtensions.getFirst();
    }

    @Nullable
    public String getPrimaryExtension() {
        ExtensionWithSource extensionWithSource = this.getPrimaryExtensionWithSource();
        return extensionWithSource == null ? null : extensionWithSource.getExtension();
    }

    public boolean hasAnyExtension() {
        return this.m_aExtensions.isNotEmpty();
    }

    public boolean containsExtension(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (ExtensionWithSource extensionWithSource : this.m_aExtensions) {
                if (!extensionWithSource.matches(string)) continue;
                return true;
            }
        }
        return false;
    }

    void addExtension(@Nonnull ExtensionWithSource extensionWithSource) {
        ValueEnforcer.notNull(extensionWithSource, "Ext");
        this.m_aExtensions.add(extensionWithSource);
    }

    void addMimeType(@Nonnull MimeTypeWithSource mimeTypeWithSource) {
        ValueEnforcer.notNull(mimeTypeWithSource, "MimeType");
        this.m_aMimeTypes.add(mimeTypeWithSource);
    }

    @Nullable
    public String getSource() {
        return this.m_sSource;
    }

    public boolean hasSource() {
        return StringHelper.hasText(this.m_sSource);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeTypeInfo mimeTypeInfo = (MimeTypeInfo)object;
        return this.m_aMimeTypes.equals(mimeTypeInfo.m_aMimeTypes);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMimeTypes)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("mimeTypes", this.m_aMimeTypes).appendIfNotNull("comment", this.m_sComment).appendIf("parentTypes", this.m_aParentTypes, CollectionHelper::isNotEmpty).appendIf("globs", this.m_aGlobs, CollectionHelper::isNotEmpty).appendIf("extensions", this.m_aExtensions, CollectionHelper::isNotEmpty).appendIfNotNull("source", this.m_sSource).getToString();
    }

    @Immutable
    public static final class ExtensionWithSource
    implements Serializable {
        private final String m_sExt;
        private final String m_sSource;
        private transient int m_nHashCode = 0;

        public ExtensionWithSource(@Nonnull String string) {
            this(string, null);
        }

        public ExtensionWithSource(@Nonnull String string, @Nullable String string2) {
            this.m_sExt = ValueEnforcer.notNull(string, "Extension");
            this.m_sSource = string2;
        }

        @Nonnull
        public String getExtension() {
            return this.m_sExt;
        }

        @Nullable
        public String getSource() {
            return this.m_sSource;
        }

        public boolean matches(@Nonnull @Nonempty String string) {
            if (this.m_sExt.contains(string)) {
                return true;
            }
            return this.m_sExt.contains(string.toLowerCase(Locale.US));
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            ExtensionWithSource extensionWithSource = (ExtensionWithSource)object;
            return this.m_sExt.equals(extensionWithSource.m_sExt) && EqualsHelper.equals(this.m_sSource, extensionWithSource.m_sSource);
        }

        public int hashCode() {
            int n = this.m_nHashCode;
            if (n == 0) {
                n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_sExt).append(this.m_sSource).getHashCode();
            }
            return n;
        }

        public String toString() {
            return new ToStringGenerator(this).append("extension", this.m_sExt).appendIfNotNull("source", this.m_sSource).getToString();
        }
    }

    @Immutable
    public static final class MimeTypeWithSource
    implements Serializable {
        private final IMimeType m_aMimeType;
        private final String m_sSource;
        private transient int m_nHashCode = 0;

        public MimeTypeWithSource(@Nonnull String string) {
            this(MimeTypeParser.parseMimeType(string), null);
        }

        public MimeTypeWithSource(@Nonnull IMimeType iMimeType) {
            this(iMimeType, null);
        }

        public MimeTypeWithSource(@Nonnull IMimeType iMimeType, @Nullable String string) {
            this.m_aMimeType = ValueEnforcer.notNull(iMimeType, "MimeType");
            this.m_sSource = string;
        }

        @Nonnull
        public IMimeType getMimeType() {
            return this.m_aMimeType;
        }

        @Nonnull
        @Nonempty
        public String getMimeTypeAsString() {
            return this.m_aMimeType.getAsString();
        }

        @Nullable
        public String getSource() {
            return this.m_sSource;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            MimeTypeWithSource mimeTypeWithSource = (MimeTypeWithSource)object;
            return this.m_aMimeType.equals(mimeTypeWithSource.m_aMimeType) && EqualsHelper.equals(this.m_sSource, mimeTypeWithSource.m_sSource);
        }

        public int hashCode() {
            int n = this.m_nHashCode;
            if (n == 0) {
                n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_aMimeType).append(this.m_sSource).getHashCode();
            }
            return n;
        }

        public String toString() {
            return new ToStringGenerator(this).append("mimeType", this.m_aMimeType).appendIfNotNull("source", this.m_sSource).getToString();
        }
    }
}

