/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.forcedredirect;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import com.helger.xservlet.forcedredirect.ForcedRedirectException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ForcedRedirectManager
extends AbstractSessionWebSingleton {
    public static final String REQUEST_PARAMETER_PRG_ACTIVE = "phprga";
    private static final Logger LOGGER = LoggerFactory.getLogger(ForcedRedirectManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, Serializable> m_aMap = new CommonsHashMap<String, Serializable>();

    @Deprecated
    @UsedViaReflection
    public ForcedRedirectManager() {
    }

    @Nonnull
    public static ForcedRedirectManager getInstance() {
        return ForcedRedirectManager.getSessionSingleton(ForcedRedirectManager.class);
    }

    @Nullable
    public static ForcedRedirectManager getInstanceIfInstantiated() {
        return ForcedRedirectManager.getSessionSingletonIfInstantiated(ForcedRedirectManager.class);
    }

    public void createForcedRedirect(@Nonnull ForcedRedirectException forcedRedirectException) {
        ValueEnforcer.notNull(forcedRedirectException, "Exception");
        this.m_aRWLock.writeLockedGet(() -> this.m_aMap.put(forcedRedirectException.getSourceMenuItemID(), forcedRedirectException.getContent()));
        if (GlobalDebug.isDebugMode()) {
            LOGGER.info("Creating forced redirect from '" + forcedRedirectException.getSourceMenuItemID() + "' to URL " + forcedRedirectException.getRedirectTargetURL().getAsStringWithEncodedParameters());
        }
    }

    @Nullable
    public Serializable getContent(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> (Serializable)this.m_aMap.get(string));
    }

    public boolean hasContent(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.get(string) != null);
    }

    @Nullable
    public static Serializable getLastForcedRedirectContent(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        ForcedRedirectManager forcedRedirectManager = ForcedRedirectManager.getInstanceIfInstantiated();
        if (forcedRedirectManager == null) {
            return null;
        }
        return forcedRedirectManager.getContent(string);
    }

    @Nullable
    public Serializable getAndRemoveContent(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        Serializable serializable = this.m_aRWLock.writeLockedGet(() -> (Serializable)this.m_aMap.remove(string));
        if (serializable != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removed content of last forced redirect from '" + string + "'");
        }
        return serializable;
    }

    @Nullable
    public static Serializable getAndRemoveLastForcedRedirectContent(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        ForcedRedirectManager forcedRedirectManager = ForcedRedirectManager.getInstanceIfInstantiated();
        if (forcedRedirectManager == null) {
            return null;
        }
        if (forcedRedirectManager.hasContent(string)) {
            return forcedRedirectManager.getAndRemoveContent(string);
        }
        return null;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("map", this.m_aMap).getToString();
    }
}

