/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.handler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.functional.IThrowingConsumer;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.servlet.async.ServletAsyncSpec;
import com.helger.xservlet.handler.IXServletHandler;
import com.helger.xservlet.handler.XServletAsyncHandler;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import com.helger.xservlet.handler.simple.XServletHandlerToSimpleHandler;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class XServletHandlerRegistry {
    private final ICommonsMap<EHttpMethod, IXServletHandler> m_aHandler = new CommonsEnumMap<EHttpMethod, IXServletHandler>(EHttpMethod.class);

    public void registerHandler(@Nonnull EHttpMethod eHttpMethod, @Nonnull IXServletHandler iXServletHandler, boolean bl) {
        ValueEnforcer.notNull(eHttpMethod, "HTTPMethod");
        ValueEnforcer.notNull(iXServletHandler, "Handler");
        if (!bl && this.m_aHandler.containsKey(eHttpMethod)) {
            throw new IllegalStateException("An HTTP handler for HTTP method " + eHttpMethod + " is already registered: " + this.m_aHandler.get(eHttpMethod));
        }
        this.m_aHandler.put(eHttpMethod, iXServletHandler);
    }

    public void registerHandler(@Nonnull EHttpMethod eHttpMethod, @Nonnull IXServletSimpleHandler iXServletSimpleHandler) {
        this.registerHandler(eHttpMethod, ServletAsyncSpec.getSync(), iXServletSimpleHandler);
    }

    public void registerHandler(@Nonnull EHttpMethod eHttpMethod, @Nonnull ServletAsyncSpec servletAsyncSpec, @Nonnull IXServletSimpleHandler iXServletSimpleHandler) {
        IXServletHandler iXServletHandler = new XServletHandlerToSimpleHandler(iXServletSimpleHandler);
        if (servletAsyncSpec.isAsynchronous()) {
            iXServletHandler = new XServletAsyncHandler(servletAsyncSpec, iXServletHandler);
        }
        this.registerHandler(eHttpMethod, iXServletHandler, false);
    }

    public EChange copyHandler(@Nonnull EHttpMethod eHttpMethod, @Nonnull @Nonempty Set<EHttpMethod> set) {
        ValueEnforcer.notNull(eHttpMethod, "FromMethod");
        ValueEnforcer.notEmptyNoNullValue(set, "ToMethods");
        IXServletHandler iXServletHandler = this.getHandler(eHttpMethod);
        if (iXServletHandler == null) {
            return EChange.UNCHANGED;
        }
        for (EHttpMethod eHttpMethod2 : set) {
            this.registerHandler(eHttpMethod2, iXServletHandler, false);
        }
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange copyHandlerToAll(@Nonnull EHttpMethod eHttpMethod) {
        EnumSet<EHttpMethod> enumSet = EnumSet.of(EHttpMethod.GET, EHttpMethod.POST, EHttpMethod.PUT, EHttpMethod.DELETE, EHttpMethod.PATCH);
        enumSet.remove(eHttpMethod);
        return this.copyHandler(eHttpMethod, enumSet);
    }

    @Nonnull
    @ReturnsMutableCopy
    public EnumSet<EHttpMethod> getAllowedHTTPMethods() {
        EnumSet<EHttpMethod> enumSet = EnumSet.copyOf(this.m_aHandler.keySet());
        if (!enumSet.contains(EHttpMethod.GET)) {
            enumSet.remove(EHttpMethod.HEAD);
        }
        return enumSet;
    }

    @Nonnull
    public String getAllowedHttpMethodsString() {
        return StringHelper.getImplodedMapped(", ", this.getAllowedHTTPMethods(), EHttpMethod::getName);
    }

    @Nullable
    public IXServletHandler getHandler(@Nonnull EHttpMethod eHttpMethod) {
        return (IXServletHandler)this.m_aHandler.get(eHttpMethod);
    }

    public void forEachHandler(@Nonnull Consumer<? super IXServletHandler> consumer) {
        this.m_aHandler.forEachValue(consumer);
    }

    public <EXTYPE extends Throwable> void forEachHandlerThrowing(@Nonnull IThrowingConsumer<? super IXServletHandler, EXTYPE> iThrowingConsumer) throws EXTYPE {
        for (IXServletHandler iXServletHandler : this.m_aHandler.values()) {
            iThrowingConsumer.accept(iXServletHandler);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("Handler", this.m_aHandler).getToString();
    }
}

