/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.handler.simple;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.http.CHttp;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.state.EContinue;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.StringHelper;
import com.helger.http.EHttpVersion;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.forcedredirect.ForcedRedirectException;
import com.helger.xservlet.handler.IXServletHandler;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.io.IOException;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XServletHandlerToSimpleHandler
implements IXServletHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XServletHandlerToSimpleHandler.class);
    private final IMutableStatisticsHandlerCounter m_aStatsHasLastModification = StatisticsManager.getCounterHandler(this.getClass().getName() + "$has-lastmodification");
    private final IMutableStatisticsHandlerCounter m_aStatsHasETag = StatisticsManager.getCounterHandler(this.getClass().getName() + "$has-etag");
    private final IMutableStatisticsHandlerCounter m_aStatsNotModifiedIfModifiedSince = StatisticsManager.getCounterHandler(this.getClass().getName() + "$notmodified.if-modified-since");
    private final IMutableStatisticsHandlerCounter m_aStatsModifiedIfModifiedSince = StatisticsManager.getCounterHandler(this.getClass().getName() + "$modified.if-modified-since");
    private final IMutableStatisticsHandlerCounter m_aStatsNotModifiedIfUnmodifiedSince = StatisticsManager.getCounterHandler(this.getClass().getName() + "$notmodified.if-unmodified-since");
    private final IMutableStatisticsHandlerCounter m_aStatsModifiedIfUnmodifiedSince = StatisticsManager.getCounterHandler(this.getClass().getName() + "$modified.if-unmodified-since");
    private final IMutableStatisticsHandlerCounter m_aStatsNotModifiedIfNonMatch = StatisticsManager.getCounterHandler(this.getClass().getName() + "$notmodified.if-unon-match");
    private final IMutableStatisticsHandlerCounter m_aStatsModifiedIfNonMatch = StatisticsManager.getCounterHandler(this.getClass().getName() + "$modified.if-unon-match");
    private final IXServletSimpleHandler m_aSimpleHandler;

    public XServletHandlerToSimpleHandler(@Nonnull IXServletSimpleHandler iXServletSimpleHandler) {
        ValueEnforcer.notNull(iXServletSimpleHandler, "SimpleHandler");
        this.m_aSimpleHandler = iXServletSimpleHandler;
    }

    @Override
    public void onServletInit(@Nonnull ICommonsMap<String, String> iCommonsMap) throws ServletException {
        this.m_aSimpleHandler.onServletInit(iCommonsMap);
    }

    private void _onException(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse, @Nonnull Throwable throwable) throws IOException, ServletException {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("An exception was caught in servlet processing for URL '" + iRequestWebScopeWithoutResponse.getURLEncoded() + "'", throwable);
        }
        if (this.m_aSimpleHandler.onException(iRequestWebScopeWithoutResponse, unifiedResponse, throwable).isContinue()) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            throw new ServletException(throwable);
        }
    }

    @Nonnull
    private EContinue _handleETag(@Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        String string;
        LocalDateTime localDateTime = this.m_aSimpleHandler.getLastModificationDateTime(iRequestWebScopeWithoutResponse);
        if (localDateTime != null) {
            long l;
            this.m_aStatsHasLastModification.increment();
            long l2 = httpServletRequest.getDateHeader("If-Modified-Since");
            if (l2 >= 0L) {
                LocalDateTime localDateTime2 = CHttp.convertMillisToLocalDateTime(l2);
                if (localDateTime.compareTo(localDateTime2) <= 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Requested resource was not modified: " + iRequestWebScopeWithoutResponse.getPathWithinServlet());
                    }
                    this.m_aStatsNotModifiedIfModifiedSince.increment();
                    return EContinue.BREAK;
                }
                this.m_aStatsModifiedIfModifiedSince.increment();
            }
            if ((l = httpServletRequest.getDateHeader("If-Unmodified-Since")) >= 0L) {
                LocalDateTime object = CHttp.convertMillisToLocalDateTime(l);
                if (localDateTime.compareTo(object) >= 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Requested resource was not modified: " + iRequestWebScopeWithoutResponse.getPathWithinServlet());
                    }
                    this.m_aStatsNotModifiedIfUnmodifiedSince.increment();
                    return EContinue.BREAK;
                }
                this.m_aStatsModifiedIfUnmodifiedSince.increment();
            }
            unifiedResponse.setLastModified(localDateTime);
        }
        if (StringHelper.hasText(string = this.m_aSimpleHandler.getSupportedETag(iRequestWebScopeWithoutResponse))) {
            this.m_aStatsHasETag.increment();
            String string2 = httpServletRequest.getHeader("If-None-Match");
            if (StringHelper.hasText(string2)) {
                ICommonsList<String> iCommonsList = RegExHelper.getSplitToList(string2, ",\\s+");
                if (iCommonsList.isEmpty()) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Empty ETag list found (" + string2 + ")");
                    }
                } else {
                    for (String string3 : iCommonsList) {
                        if (!string.equals(string3)) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Requested resource has the same E-Tag: " + iRequestWebScopeWithoutResponse.getPathWithinServlet());
                        }
                        this.m_aStatsNotModifiedIfNonMatch.increment();
                        return EContinue.BREAK;
                    }
                }
                this.m_aStatsModifiedIfNonMatch.increment();
            }
            unifiedResponse.setETagIfApplicable(string);
        }
        return EContinue.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) throws ServletException, IOException {
        UnifiedResponse unifiedResponse = this.m_aSimpleHandler.createUnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest, iRequestWebScope);
        if (this.m_aSimpleHandler.initRequestState(iRequestWebScope, unifiedResponse).isBreak()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cancelled request after initRequestState with response " + unifiedResponse);
            }
        } else {
            boolean bl = true;
            if ((eHttpMethod == EHttpMethod.GET || eHttpMethod == EHttpMethod.HEAD) && this._handleETag(httpServletRequest, iRequestWebScope, unifiedResponse).isBreak()) {
                unifiedResponse.setStatus(304);
                bl = false;
            }
            if (bl) {
                try {
                    this.m_aSimpleHandler.onRequestBegin(iRequestWebScope);
                }
                catch (Exception exception) {
                    this._onException(iRequestWebScope, unifiedResponse, exception);
                }
                Exception exception = null;
                try {
                    this.m_aSimpleHandler.handleRequest(iRequestWebScope, unifiedResponse);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Successfully handled request: " + iRequestWebScope.getPathWithinServlet());
                    }
                }
                catch (ForcedRedirectException forcedRedirectException) {
                    throw forcedRedirectException;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    this._onException(iRequestWebScope, unifiedResponse, exception2);
                }
                finally {
                    try {
                        this.m_aSimpleHandler.onRequestEnd(exception);
                    }
                    catch (Exception exception3) {
                        LOGGER.error("onRequestEnd failed", exception3);
                    }
                }
            }
        }
        unifiedResponse.applyToResponse(httpServletResponse);
    }

    @Override
    public void onServletDestroy() {
        this.m_aSimpleHandler.onServletDestroy();
    }
}

