/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.config.source.res.AbstractConfigurationSourceResource;
import com.helger.config.source.res.ConfigurationSourceJson;
import com.helger.config.source.res.ConfigurationSourceProperties;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

enum EConfigSourceResourceType {
    JSON("json", iReadableResource -> new ConfigurationSourceJson((IReadableResource)iReadableResource, StandardCharsets.UTF_8)),
    PROPERTIES("properties", iReadableResource -> new ConfigurationSourceProperties((IReadableResource)iReadableResource, StandardCharsets.UTF_8));

    private final String m_sExt;
    private final Function<IReadableResource, AbstractConfigurationSourceResource> m_aFactory;

    private EConfigSourceResourceType(String string2, Function<IReadableResource, AbstractConfigurationSourceResource> function) {
        this.m_sExt = string2;
        this.m_aFactory = function;
    }

    @Nonnull
    @Nonempty
    public String getExtension() {
        return this.m_sExt;
    }

    @Nonnull
    @Nonempty
    public AbstractConfigurationSourceResource createConfigurationSource(@Nonnull IReadableResource iReadableResource) {
        return this.m_aFactory.apply(iReadableResource);
    }

    @Nullable
    public static EConfigSourceResourceType getFromExtensionOrNull(@Nullable String string) {
        return EConfigSourceResourceType.getFromExtensionOrDefault(string, null);
    }

    @Nullable
    public static EConfigSourceResourceType getFromExtensionOrDefault(@Nullable String string, @Nullable EConfigSourceResourceType eConfigSourceResourceType) {
        if (StringHelper.hasText(string)) {
            for (EConfigSourceResourceType eConfigSourceResourceType2 : EConfigSourceResourceType.values()) {
                if (!eConfigSourceResourceType2.m_sExt.equalsIgnoreCase(string)) continue;
                return eConfigSourceResourceType2;
            }
        }
        return eConfigSourceResourceType;
    }
}

