/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.dsd;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.peppolid.factory.IIdentifierFactory;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.dsd.DSDDatasetResponse;
import eu.toop.edm.jaxb.cv.agent.PublicOrganizationType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;
import eu.toop.edm.jaxb.dcatap.DCatAPDistributionType;
import java.util.List;
import javax.annotation.Nonnull;

public final class DSDDatasetHelper {
    private DSDDatasetHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<DSDDatasetResponse> buildDSDResponseSet(@Nonnull List<DCatAPDatasetType> list) {
        IIdentifierFactory iIdentifierFactory = TCConfig.getIdentifierFactory();
        CommonsHashSet<DSDDatasetResponse> commonsHashSet = new CommonsHashSet<DSDDatasetResponse>();
        for (DCatAPDatasetType dCatAPDatasetType : list) {
            for (DCatAPDistributionType dCatAPDistributionType : dCatAPDatasetType.getDistribution()) {
                DSDDatasetResponse dSDDatasetResponse = new DSDDatasetResponse();
                if (dCatAPDistributionType.getAccessService().hasConformsToEntries()) {
                    dSDDatasetResponse.setAccessServiceConforms(dCatAPDistributionType.getAccessService().getConformsToAtIndex(0).getValue());
                }
                IDType iDType = ((PublicOrganizationType)dCatAPDatasetType.getPublisherAtIndex(0)).getIdAtIndex(0);
                dSDDatasetResponse.setDPIdentifier(iIdentifierFactory.createParticipantIdentifier(iDType.getSchemeName(), iDType.getValue()));
                ICommonsList<String> iCommonsList = StringHelper.getExploded("::", dCatAPDistributionType.getAccessService().getIdentifier(), 2);
                if (iCommonsList.size() == 2) {
                    dSDDatasetResponse.setDocumentTypeIdentifier(iIdentifierFactory.createDocumentTypeIdentifier((String)iCommonsList.get(0), (String)iCommonsList.get(1)));
                }
                dSDDatasetResponse.setDatasetIdentifier(dCatAPDatasetType.getIdentifierAtIndex(0));
                if (dCatAPDistributionType.hasConformsToEntries()) {
                    dSDDatasetResponse.setDistributionConforms(dCatAPDistributionType.getConformsToAtIndex(0).getValue());
                }
                if (dCatAPDistributionType.getFormat().hasContentEntries()) {
                    dSDDatasetResponse.setDistributionFormat(dCatAPDistributionType.getFormat().getContentAtIndex(0).toString());
                }
                commonsHashSet.add(dSDDatasetResponse);
            }
        }
        return commonsHashSet;
    }
}

