/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import eu.toop.connector.api.me.model.MEPayload;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MEMessage
implements Serializable {
    private final IParticipantIdentifier m_aSenderID;
    private final IParticipantIdentifier m_aReceiverID;
    private final IDocumentTypeIdentifier m_aDocTypeID;
    private final IProcessIdentifier m_aProcessID;
    private final ICommonsList<MEPayload> m_aPayloads = new CommonsArrayList<MEPayload>();

    protected MEMessage(@Nullable IParticipantIdentifier iParticipantIdentifier, @Nullable IParticipantIdentifier iParticipantIdentifier2, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable IProcessIdentifier iProcessIdentifier, @Nonnull @Nonempty ICommonsList<MEPayload> iCommonsList) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "Payloads");
        this.m_aSenderID = iParticipantIdentifier;
        this.m_aReceiverID = iParticipantIdentifier2;
        this.m_aDocTypeID = iDocumentTypeIdentifier;
        this.m_aProcessID = iProcessIdentifier;
        this.m_aPayloads.addAll(iCommonsList);
    }

    @Nullable
    public IParticipantIdentifier getSenderID() {
        return this.m_aSenderID;
    }

    @Nullable
    public IParticipantIdentifier getReceiverID() {
        return this.m_aReceiverID;
    }

    @Nullable
    public IDocumentTypeIdentifier getDoctypeID() {
        return this.m_aDocTypeID;
    }

    @Nullable
    public IProcessIdentifier getProcessID() {
        return this.m_aProcessID;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableObject
    public ICommonsList<MEPayload> payloads() {
        return this.m_aPayloads;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<MEPayload> getAllPayloads() {
        return (ICommonsList)this.m_aPayloads.getClone();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IParticipantIdentifier m_aSenderID;
        private IParticipantIdentifier m_aReceiverID;
        private IDocumentTypeIdentifier m_aDocTypeID;
        private IProcessIdentifier m_aProcessID;
        private final ICommonsList<MEPayload> m_aPayloads = new CommonsArrayList<MEPayload>();

        protected Builder() {
        }

        @Nonnull
        public Builder senderID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
            this.m_aSenderID = iParticipantIdentifier;
            return this;
        }

        @Nonnull
        public Builder receiverID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
            this.m_aReceiverID = iParticipantIdentifier;
            return this;
        }

        @Nonnull
        public Builder docTypeID(@Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
            this.m_aDocTypeID = iDocumentTypeIdentifier;
            return this;
        }

        @Nonnull
        public Builder processID(@Nullable IProcessIdentifier iProcessIdentifier) {
            this.m_aProcessID = iProcessIdentifier;
            return this;
        }

        @Nonnull
        public Builder addPayload(@Nullable Consumer<? super MEPayload.Builder> consumer) {
            if (consumer != null) {
                MEPayload.Builder builder = MEPayload.builder();
                consumer.accept(builder);
                this.addPayload(builder);
            }
            return this;
        }

        @Nonnull
        public Builder addPayload(@Nullable MEPayload.Builder builder) {
            return this.addPayload(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder addPayload(@Nullable MEPayload mEPayload) {
            if (mEPayload != null) {
                this.m_aPayloads.add(mEPayload);
            }
            return this;
        }

        @Nonnull
        public Builder payload(@Nullable Consumer<? super MEPayload.Builder> consumer) {
            if (consumer != null) {
                MEPayload.Builder builder = MEPayload.builder();
                consumer.accept(builder);
                this.payload(builder);
            }
            return this;
        }

        @Nonnull
        public Builder payload(@Nullable MEPayload.Builder builder) {
            return this.payload(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder payload(@Nullable MEPayload mEPayload) {
            if (mEPayload != null) {
                this.m_aPayloads.set(mEPayload);
            } else {
                this.m_aPayloads.clear();
            }
            return this;
        }

        @Nonnull
        public Builder payloads(MEPayload ... mEPayloadArray) {
            this.m_aPayloads.setAll((MEPayload[])mEPayloadArray);
            return this;
        }

        @Nonnull
        public Builder payloads(@Nullable Iterable<MEPayload> iterable) {
            this.m_aPayloads.setAll(iterable);
            return this;
        }

        public void checkConsistency() {
            if (this.m_aPayloads.isEmpty()) {
                throw new IllegalStateException("At least one payload MUST be present");
            }
        }

        @Nonnull
        public MEMessage build() {
            this.checkConsistency();
            return new MEMessage(this.m_aSenderID, this.m_aReceiverID, this.m_aDocTypeID, this.m_aProcessID, this.m_aPayloads);
        }
    }
}

