/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.io.stream.WrappedInputStream;
import com.helger.commons.io.stream.WrappedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class TCDumpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCDumpHelper.class);

    private TCDumpHelper() {
    }

    @Nonnull
    public static InputStream getDumpInputStream(@Nonnull InputStream inputStream, @Nullable File file, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(inputStream, "SrcIS");
        ValueEnforcer.notEmpty(string, "ContextAndExtension");
        if (file != null) {
            FileOutputStream fileOutputStream;
            String string2 = Long.toString(System.nanoTime()) + string;
            File file2 = new File(file, string2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to open DumpInputStream file " + file2.getAbsolutePath());
            }
            if ((fileOutputStream = FileHelper.getOutputStream(file2)) != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Dumping InputStream to " + file2.getAbsolutePath());
                }
                return new WrappedInputStream(inputStream){

                    @Override
                    public int read() throws IOException {
                        int n = super.read();
                        if (n >= 0) {
                            fileOutputStream.write((byte)n);
                        }
                        return n;
                    }

                    @Override
                    public int read(byte[] byArray) throws IOException {
                        return this.read(byArray, 0, byArray.length);
                    }

                    @Override
                    public int read(byte[] byArray, int n, int n2) throws IOException {
                        int n3 = super.read(byArray, n, n2);
                        if (n3 >= 0) {
                            fileOutputStream.write(byArray, n, n3);
                        }
                        return n3;
                    }

                    @Override
                    public void close() throws IOException {
                        try {
                            StreamHelper.close(fileOutputStream);
                        }
                        finally {
                            super.close();
                        }
                    }
                };
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to open DumpInputStream file '" + file2.getAbsolutePath() + "' for writing");
            }
        }
        return inputStream;
    }

    @Nonnull
    public static OutputStream getDumpOutputStream(@Nonnull OutputStream outputStream, @Nullable File file, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(outputStream, "SrcOS");
        ValueEnforcer.notEmpty(string, "ContextAndExtension");
        if (file != null) {
            FileOutputStream fileOutputStream;
            String string2 = Long.toString(System.nanoTime()) + string;
            File file2 = new File(file, string2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to open DumpOutputStream file " + file2.getAbsolutePath());
            }
            if ((fileOutputStream = FileHelper.getOutputStream(file2)) != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Dumping OutputStream to " + file2.getAbsolutePath());
                }
                return new WrappedOutputStream(outputStream){

                    @Override
                    public void write(int n) throws IOException {
                        super.write(n);
                        fileOutputStream.write(n);
                    }

                    @Override
                    public void write(byte[] byArray) throws IOException {
                        this.write(byArray, 0, byArray.length);
                    }

                    @Override
                    public void write(byte[] byArray, int n, int n2) throws IOException {
                        super.write(byArray, n, n2);
                        fileOutputStream.write(byArray, n, n2);
                    }

                    @Override
                    public void flush() throws IOException {
                        try {
                            fileOutputStream.flush();
                        }
                        finally {
                            super.flush();
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        try {
                            fileOutputStream.close();
                        }
                        finally {
                            super.close();
                        }
                    }
                };
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to open DumpOutputStream file '" + file2.getAbsolutePath() + "' for writing");
            }
        }
        return outputStream;
    }
}

