/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.dsd;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.dsd.DSDDatasetHelper;
import eu.toop.connector.api.dsd.DSDDatasetResponse;
import eu.toop.connector.api.dsd.IDSDDatasetResponseProvider;
import eu.toop.connector.api.error.ITCErrorHandler;
import eu.toop.connector.api.http.TCHttpClientSettings;
import eu.toop.dsd.client.DSDClient;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSDDatasetResponseProviderRemote
implements IDSDDatasetResponseProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DSDDatasetResponseProviderRemote.class);
    private final String m_sBaseURL;

    public DSDDatasetResponseProviderRemote() {
        this(TCConfig.DSD.getDSDBaseUrl());
    }

    public DSDDatasetResponseProviderRemote(@Nonnull String string) {
        ValueEnforcer.notEmpty(string, "BaseURL");
        this.m_sBaseURL = string;
    }

    @Nonnull
    @Nonempty
    public final String getBaseURL() {
        return this.m_sBaseURL;
    }

    @Override
    @Nonnull
    public ICommonsSet<DSDDatasetResponse> getAllDatasetResponses(@Nonnull String string, @Nonnull String string2, @Nullable String string3, @Nonnull ITCErrorHandler iTCErrorHandler) {
        ICommonsSet<DSDDatasetResponse> iCommonsSet;
        DSDClient dSDClient = new DSDClient(this.m_sBaseURL);
        dSDClient.setHttpClientSettings(new TCHttpClientSettings());
        try {
            List<DCatAPDatasetType> list = dSDClient.queryDataset(string2, string3);
            iCommonsSet = DSDDatasetHelper.buildDSDResponseSet(list);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error(runtimeException.getMessage(), runtimeException);
            iTCErrorHandler.onError("Failed to query the DSD", runtimeException, EToopErrorCode.DD_001);
            iCommonsSet = new CommonsHashSet<DSDDatasetResponse>();
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, string + "DSD querying '" + string2 + "' and country code '" + string3 + "' lead to " + iCommonsSet.size() + " result entries");
        return iCommonsSet;
    }

    public String toString() {
        return new ToStringGenerator(this).append("BaseURL", this.m_sBaseURL).getToString();
    }
}

