/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.validation;

import com.helger.bdve.api.EValidationType;
import com.helger.bdve.api.artefact.ValidationArtefact;
import com.helger.bdve.api.execute.ValidationExecutionManager;
import com.helger.bdve.api.executorset.IValidationExecutorSet;
import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.executorset.ValidationExecutorSetRegistry;
import com.helger.bdve.api.result.ValidationResult;
import com.helger.bdve.api.result.ValidationResultList;
import com.helger.bdve.engine.source.IValidationSourceXML;
import com.helger.bdve.engine.source.ValidationSourceXML;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.io.resource.inmemory.ReadableResourceByteArray;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.sax.WrappedCollectingSAXErrorHandler;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import eu.toop.connector.api.validation.IVSValidator;
import eu.toop.connector.app.validation.TCValidationRules;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;

public class TCValidator
implements IVSValidator {
    private static final ValidationExecutorSetRegistry<IValidationSourceXML> VER = new ValidationExecutorSetRegistry();

    @Nonnull
    public static ValidationExecutorSetRegistry<IValidationSourceXML> internalGetRegistry() {
        return VER;
    }

    @Nonnull
    public static IValidationExecutorSet<IValidationSourceXML> getVES(@Nonnull VESID vESID) {
        IValidationExecutorSet<IValidationSourceXML> iValidationExecutorSet = VER.getOfID(vESID);
        if (iValidationExecutorSet == null) {
            throw new IllegalStateException("Unexpected VESID '" + vESID.getAsSingleID() + "'");
        }
        return iValidationExecutorSet;
    }

    @Override
    @Nonnull
    public ValidationResultList validate(@Nonnull VESID vESID, @Nonnull byte[] byArray, @Nonnull Locale locale) {
        ErrorList errorList = new ErrorList();
        ValidationResultList validationResultList = new ValidationResultList();
        ReadableResourceByteArray readableResourceByteArray = new ReadableResourceByteArray(byArray);
        Document document = DOMReader.readXMLDOM(readableResourceByteArray, (IDOMReaderSettings)new DOMReaderSettings().setErrorHandler(new WrappedCollectingSAXErrorHandler(errorList)).setLocale(locale).setFeatureValues(EXMLParserFeature.AVOID_XML_ATTACKS));
        if (document != null) {
            ValidationSourceXML validationSourceXML = ValidationSourceXML.create("uploaded content", DOMReader.readXMLDOM(byArray));
            ValidationExecutionManager.executeValidation(TCValidator.getVES(vESID), validationSourceXML, validationResultList, locale);
        }
        validationResultList.add(0, new ValidationResult(new ValidationArtefact(EValidationType.XML, readableResourceByteArray), errorList));
        return validationResultList;
    }

    static {
        TCValidationRules.initToopEDM(VER);
    }
}

