/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.jetty;

import com.helger.commons.io.resource.ClassPathResource;
import com.helger.photon.jetty.JettyStarter;
import com.helger.photon.jetty.JettyStopper;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Standalone TOOP Connector NG"}, name="tc-jetty", mixinStandardHelpOptions=true, separator=" ")
public class MainTC
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainTC.class);
    @CommandLine.Option(names={"-p", "--port"}, paramLabel="Port", defaultValue="8080", description={"Port to run the TOOP Connector on (default: ${DEFAULT-VALUE})"})
    private Integer m_aStartPort;
    @CommandLine.Option(names={"-s", "--stopPort"}, paramLabel="Stop Port", defaultValue="8079", description={"Internal port to watch for the shutdown command (default: ${DEFAULT-VALUE})"})
    private Integer m_aStopPort;
    @CommandLine.Parameters(arity="1", paramLabel="command", description={"What to do. Options are ${COMPLETION-CANDIDATES}"})
    private ECommand m_eCommand;

    @Override
    public Integer call() throws Exception {
        try {
            switch (this.m_eCommand) {
                case start: {
                    JettyStarter jettyStarter = new JettyStarter("Standalone TOOP Connector NG");
                    jettyStarter.setPort(this.m_aStartPort).setStopPort(this.m_aStopPort).setSessionCookieName("TOOP_TC_SESSION").setContainerIncludeJarPattern(".*\\.jar$*|.*/classes/.*");
                    ClassPathResource classPathResource = new ClassPathResource("WEB-INF/web.xml");
                    if (!classPathResource.exists()) {
                        throw new IllegalStateException();
                    }
                    String string = classPathResource.getAsURL().toExternalForm();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Using web.xml resource: '" + string + "'");
                    }
                    jettyStarter.setWebXmlResource(classPathResource.getAsURL().toExternalForm());
                    jettyStarter.run();
                    break;
                }
                case stop: {
                    new JettyStopper().setStopPort(this.m_aStopPort).run();
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to do that");
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error running TC NG Standalone", exception);
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        CommandLine commandLine = new CommandLine(new MainTC());
        commandLine.setCaseInsensitiveEnumValuesAllowed(true);
        int n = commandLine.execute(stringArray);
        System.exit(n);
    }

    static enum ECommand {
        start,
        stop;

    }
}

