/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.external;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.mime.MimeTypeParserException;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.ResourceStreamSource;
import com.helger.xml.transform.TransformSourceFactory;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.incoming.MEIncomingException;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import eu.toop.connector.api.me.outgoing.MEOutgoingException;
import eu.toop.connector.mem.external.DateTimeUtils;
import eu.toop.connector.mem.external.ResultType;
import eu.toop.connector.mem.external.SoapUtil;
import eu.toop.connector.mem.external.SoapXPathUtil;
import eu.toop.connector.mem.external.SubmissionMessageProperties;
import eu.toop.connector.mem.external.notifications.RelayResult;
import eu.toop.connector.mem.external.notifications.SubmissionResult;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.bind.DatatypeConverter;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class EBMSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EBMSUtils.class);
    public static final String NS_SOAPENV = "http://www.w3.org/2003/05/soap-envelope";
    public static final String NS_EBMS = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/";

    private EBMSUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] createSuccessReceipt(SOAPMessage sOAPMessage) throws MEIncomingException {
        ValueEnforcer.notNull(sOAPMessage, "SOAPMessage");
        try {
            ResourceStreamSource resourceStreamSource = TransformSourceFactory.create(new ClassPathResource("/receipt-generator.xslt"));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer(resourceStreamSource);
            transformer.setParameter("messageid", EBMSUtils.genereateEbmsMessageId("message-exchange.toop.eu"));
            transformer.setParameter("timestamp", DateTimeUtils.getCurrentTimestamp());
            try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
                transformer.transform(new DOMSource(sOAPMessage.getSOAPPart()), new StreamResult(nonBlockingByteArrayOutputStream));
                byte[] byArray = nonBlockingByteArrayOutputStream.toByteArray();
                return byArray;
            }
        }
        catch (RuntimeException | TransformerException exception) {
            throw new MEIncomingException("Failed to create success receipt", exception);
        }
    }

    public static byte[] createFault(@Nullable SOAPMessage sOAPMessage, @Nullable String string) throws MEIncomingException {
        String string2 = string != null ? string : "Unknown Error";
        String string3 = sOAPMessage != null ? EBMSUtils.getMessageId(sOAPMessage) : "";
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(NS_SOAPENV, "Envelope");
        ICloneable<IMicroNode> iCloneable = iMicroElement.appendElement(NS_SOAPENV, "Head");
        IMicroElement iMicroElement2 = iCloneable.appendElement(NS_EBMS, "Messaging");
        IMicroElement iMicroElement3 = iMicroElement2.appendElement(NS_EBMS, "SignalMessage");
        IMicroElement iMicroElement4 = iMicroElement3.appendElement(NS_EBMS, "MessageInfo");
        iMicroElement4.appendElement(NS_EBMS, "Timestamp").appendText(DateTimeUtils.getCurrentTimestamp());
        String string4 = EBMSUtils.genereateEbmsMessageId("message-exchange.toop.eu");
        iMicroElement4.appendElement(NS_EBMS, "MessageId").appendText(string4);
        iMicroElement4 = iMicroElement3.appendElement(NS_EBMS, "Error");
        iMicroElement4.setAttribute("category", "CONTENT");
        iMicroElement4.setAttribute("errorCode", "EBMS:0004");
        iMicroElement4.setAttribute("origin", "ebms");
        iMicroElement4.setAttribute("refToMessageInError", string3);
        iMicroElement4.setAttribute("severity", "failure");
        iMicroElement4.setAttribute("shortDescription", "Error");
        ((IMicroElement)iMicroElement4.appendElement(NS_EBMS, "Description").setAttribute("http://www.w3.org/XML/1998/namespace", "lang", "en")).appendText(string2);
        iMicroElement4.appendElement(NS_EBMS, "ErrorDetail").appendText(string2);
        iCloneable = iMicroElement.appendElement(NS_SOAPENV, "Body");
        iMicroElement2 = iCloneable.appendElement(NS_SOAPENV, "Fault");
        iMicroElement3 = iMicroElement2.appendElement(NS_SOAPENV, "Code");
        iMicroElement3.appendElement(NS_SOAPENV, "Value").appendText("env:Receiver");
        iMicroElement3 = iMicroElement2.appendElement(NS_SOAPENV, "Reason");
        ((IMicroElement)iMicroElement3.appendElement(NS_SOAPENV, "Text").setAttribute("http://www.w3.org/XML/1998/namespace", "lang", "en")).appendText(string2);
        iCloneable = new MapBasedNamespaceContext();
        ((MapBasedNamespaceContext)iCloneable).addMapping("env", NS_SOAPENV);
        ((MapBasedNamespaceContext)iCloneable).addMapping("eb", NS_EBMS);
        return MicroWriter.getNodeAsBytes(microDocument, new XMLWriterSettings().setNamespaceContext((INamespaceContext)((Object)iCloneable)));
    }

    public static String genereateEbmsMessageId(String string) {
        return UUID.randomUUID().toString() + "@" + string;
    }

    @Nullable
    private static IMicroElement _property(@Nonnull String string, @Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        MicroElement microElement = new MicroElement(NS_EBMS, "Property");
        ((IMicroElement)microElement.setAttribute("name", string)).appendText(string2);
        return microElement;
    }

    public static SOAPMessage convert2MEOutboundAS4Message(SubmissionMessageProperties submissionMessageProperties, MEMessage mEMessage) throws MEOutgoingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Convert submission data to SOAP Message");
        }
        try {
            Object object;
            MicroDocument microDocument = new MicroDocument();
            IMicroElement iMicroElement = microDocument.appendElement(NS_EBMS, "Messaging");
            iMicroElement.setAttribute(NS_SOAPENV, "mustUnderstand", "true");
            IMicroElement iMicroElement2 = iMicroElement.appendElement(NS_EBMS, "UserMessage");
            ICloneable<IMicroNode> iCloneable = iMicroElement2.appendElement(NS_EBMS, "MessageInfo");
            iCloneable.appendElement(NS_EBMS, "Timestamp").appendText(DateTimeUtils.getCurrentTimestamp());
            Object object3 = EBMSUtils.genereateEbmsMessageId("message-exchange.toop.eu");
            iCloneable.appendElement(NS_EBMS, "MessageId").appendText((CharSequence)object3);
            iCloneable = iMicroElement2.appendElement(NS_EBMS, "PartyInfo");
            object3 = iCloneable.appendElement(NS_EBMS, "From");
            object3.appendElement(NS_EBMS, "PartyId").appendText(TCConfig.MEM.getMEMAS4TcPartyid());
            object3.appendElement(NS_EBMS, "Role").appendText("http://www.toop.eu/edelivery/backend");
            object3 = iCloneable.appendElement(NS_EBMS, "To");
            object3.appendElement(NS_EBMS, "PartyId").appendText(TCConfig.MEM.getMEMAS4GwPartyID());
            object3.appendElement(NS_EBMS, "Role").appendText("http://www.toop.eu/edelivery/gateway");
            iCloneable = iMicroElement2.appendElement(NS_EBMS, "CollaborationInfo");
            iCloneable.appendElement(NS_EBMS, "Service").appendText("http://www.toop.eu/edelivery/bit");
            iCloneable.appendElement(NS_EBMS, "Action").appendText("Submit");
            iCloneable.appendElement(NS_EBMS, "ConversationId").appendText(submissionMessageProperties.conversationId);
            iCloneable = iMicroElement2.appendElement(NS_EBMS, "MessageProperties");
            iCloneable.appendChild(EBMSUtils._property("ToPartyId", submissionMessageProperties.toPartyId));
            iCloneable.appendChild(EBMSUtils._property("ToPartyIdType", submissionMessageProperties.toPartyIdType));
            iCloneable.appendChild(EBMSUtils._property("ToPartyRole", submissionMessageProperties.toPartyRole));
            iCloneable.appendChild(EBMSUtils._property("ToPartyCertificate", submissionMessageProperties.toPartyCertificate));
            iCloneable.appendChild(EBMSUtils._property("TargetURL", submissionMessageProperties.targetURL));
            iCloneable.appendChild(EBMSUtils._property("Service", submissionMessageProperties.service));
            iCloneable.appendChild(EBMSUtils._property("ServiceType", submissionMessageProperties.serviceType));
            iCloneable.appendChild(EBMSUtils._property("Action", submissionMessageProperties.action));
            iCloneable.appendChild(EBMSUtils._property("MessageId", submissionMessageProperties.messageId));
            iCloneable.appendChild(EBMSUtils._property("RefToMessageId", submissionMessageProperties.refToMessageId));
            iCloneable.appendChild(EBMSUtils._property("ConversationId", submissionMessageProperties.conversationId));
            iCloneable.appendChild(EBMSUtils._property("originalSender", submissionMessageProperties.senderId != null ? submissionMessageProperties.senderId.getURIEncoded() : null));
            iCloneable.appendChild(EBMSUtils._property("finalRecipient", submissionMessageProperties.receiverId != null ? submissionMessageProperties.receiverId.getURIEncoded() : null));
            iCloneable = iMicroElement2.appendElement(NS_EBMS, "PayloadInfo");
            for (MEPayload object22 : mEMessage.payloads()) {
                object = iCloneable.appendElement(NS_EBMS, "PartInfo");
                object.setAttribute("href", "cid:" + object22.getContentID());
                IMicroElement iMicroElement3 = object.appendElement(NS_EBMS, "PartProperties");
                iMicroElement3.appendChild(EBMSUtils._property("MimeType", object22.getMimeTypeString()));
            }
            iCloneable = new MapBasedNamespaceContext();
            ((MapBasedNamespaceContext)iCloneable).addMapping("env", NS_SOAPENV);
            ((MapBasedNamespaceContext)iCloneable).addMapping("eb", NS_EBMS);
            object3 = DOMReader.readXMLDOM(MicroWriter.getNodeAsBytes(microDocument, new XMLWriterSettings().setNamespaceContext((INamespaceContext)((Object)iCloneable)))).getDocumentElement();
            SOAPMessage sOAPMessage = SoapUtil.createEmptyMessage();
            object = sOAPMessage.getSOAPHeader().getOwnerDocument().importNode((Node)object3, true);
            sOAPMessage.getSOAPHeader().appendChild((Node)object);
            for (MEPayload mEPayload : mEMessage.payloads()) {
                AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
                attachmentPart.setContentId('<' + mEPayload.getContentID() + '>');
                try {
                    attachmentPart.setRawContentBytes(mEPayload.getData().bytes(), mEPayload.getData().getOffset(), mEPayload.getData().size(), mEPayload.getMimeTypeString());
                }
                catch (SOAPException sOAPException) {
                    throw new MEOutgoingException("Failed to read payload", (Throwable)sOAPException);
                }
                sOAPMessage.addAttachmentPart(attachmentPart);
            }
            if (sOAPMessage.saveRequired()) {
                sOAPMessage.saveChanges();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(SoapUtil.describe(sOAPMessage));
            }
            return sOAPMessage;
        }
        catch (RuntimeException | SOAPException exception) {
            throw new MEOutgoingException("Unspecific error", (Throwable)exception);
        }
    }

    public static MEMessage soap2MEMessage(@Nonnull SOAPMessage sOAPMessage) throws MEIncomingException {
        IProcessIdentifier iProcessIdentifier;
        IDocumentTypeIdentifier iDocumentTypeIdentifier;
        IParticipantIdentifier iParticipantIdentifier;
        IParticipantIdentifier iParticipantIdentifier2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        Object object6;
        SOAPHeader sOAPHeader;
        ValueEnforcer.notNull(sOAPMessage, "SOAPMessage");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Convert message to submission data");
        }
        MEMessage.Builder builder = MEMessage.builder();
        try {
            sOAPHeader = sOAPMessage.getSOAPHeader();
        }
        catch (SOAPException sOAPException) {
            throw new MEIncomingException(sOAPException.getMessage(), sOAPException);
        }
        if (sOAPMessage.countAttachments() > 0) {
            object6 = sOAPMessage.getAttachments();
            while (object6.hasNext()) {
                object5 = (AttachmentPart)object6.next();
                string = RegExHelper.stringReplacePattern("<|>", ((AttachmentPart)object5).getContentId(), "");
                try {
                    object4 = SoapXPathUtil.safeFindSingleNode(sOAPHeader, "//:PayloadInfo/:PartInfo[@href='cid:" + string + "']");
                }
                catch (Exception exception) {
                    throw new MEIncomingException("ContentId: " + string + " was not found in PartInfo");
                }
                try {
                    object3 = SoapXPathUtil.getSingleNodeTextContent((Node)object4, ".//:PartProperties/:Property[@name='MimeType']");
                    if (((String)object3).startsWith("cid:")) {
                        object3 = ((String)object3).substring(4);
                    }
                    object2 = MimeTypeParser.parseMimeType((String)object3);
                }
                catch (MimeTypeParserException mimeTypeParserException) {
                    LOG.warn("Error parsing MIME type: " + mimeTypeParserException.getMessage());
                    object2 = MimeTypeParser.parseMimeType(((AttachmentPart)object5).getContentType());
                }
                try {
                    object3 = SoapXPathUtil.findSingleNode((Node)object4, ".//:PartProperties/:Property[@name='CharacterSet']/text()");
                    if (object3 != null && (object = CharsetHelper.getCharsetFromNameOrNull(object3.getNodeValue())) != null) {
                        ((MimeType)object2).addParameter("charset", ((Charset)object).name());
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                try {
                    object3 = ((AttachmentPart)object5).getRawContentBytes();
                }
                catch (SOAPException sOAPException) {
                    throw new MEIncomingException("Failed to read payload", sOAPException);
                }
                object = MEPayload.builder().mimeType((IMimeType)object2).contentID(string).data((byte[])object3).build();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("\tpayload.payloadId: " + ((MEPayload)object).getContentID());
                    LOG.debug("\tpayload.mimeType: " + ((MEPayload)object).getMimeTypeString());
                }
                builder.addPayload((MEPayload)object);
            }
        }
        object6 = SoapXPathUtil.safeFindSingleNode(sOAPHeader, "//:MessageProperties");
        try {
            object5 = SoapXPathUtil.getSingleNodeTextContent((Node)object6, ".//:Property[@name='originalSender']/@type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object5 = null;
        }
        string = SoapXPathUtil.getSingleNodeTextContent((Node)object6, ".//:Property[@name='originalSender']/text()");
        try {
            object4 = SoapXPathUtil.getSingleNodeTextContent((Node)object6, ".//:Property[@name='finalRecipient']/@type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object4 = null;
        }
        object2 = SoapXPathUtil.getSingleNodeTextContent((Node)object6, ".//:Property[@name='finalRecipient']/text()");
        object3 = SoapXPathUtil.getSingleNodeTextContent((Node)object6, ".//:Property[@name='Action']/text()");
        try {
            object = SoapXPathUtil.getSingleNodeTextContent((Node)object6, ".//:Property[@name='ServiceType']/text()");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = null;
        }
        String string2 = SoapXPathUtil.getSingleNodeTextContent((Node)object6, ".//:Property[@name='Service']/text()");
        IIdentifierFactory iIdentifierFactory = TCConfig.getIdentifierFactory();
        IParticipantIdentifier iParticipantIdentifier3 = iParticipantIdentifier2 = object5 != null ? iIdentifierFactory.createParticipantIdentifier((String)object5, string) : iIdentifierFactory.parseParticipantIdentifier(string);
        if (iParticipantIdentifier2 == null) {
            LOG.warn("Failed to create/parse sender participant identifier '" + (String)object5 + "' and '" + string + "'");
        }
        IParticipantIdentifier iParticipantIdentifier4 = iParticipantIdentifier = object4 != null ? iIdentifierFactory.createParticipantIdentifier((String)object4, (String)object2) : iIdentifierFactory.parseParticipantIdentifier((String)object2);
        if (iParticipantIdentifier == null) {
            LOG.warn("Failed to create/parse receiver participant identifier '" + (String)object4 + "' and '" + (String)object2 + "'");
        }
        if ((iDocumentTypeIdentifier = iIdentifierFactory.parseDocumentTypeIdentifier((String)object3)) == null) {
            LOG.warn("Failed to parse document type identifier '" + (String)object3 + "'");
        }
        IProcessIdentifier iProcessIdentifier2 = iProcessIdentifier = object != null ? iIdentifierFactory.createProcessIdentifier((String)object, string2) : iIdentifierFactory.parseProcessIdentifier(string2);
        if (iProcessIdentifier == null) {
            LOG.warn("Failed to create/parse process identifier '" + (String)object + "' and '" + string2 + "'");
        }
        return builder.senderID(iParticipantIdentifier2).receiverID(iParticipantIdentifier).processID(iProcessIdentifier).docTypeID(iDocumentTypeIdentifier).build();
    }

    public static RelayResult soap2RelayResult(SOAPMessage sOAPMessage) throws MEIncomingException {
        ValueEnforcer.notNull(sOAPMessage, "Notification");
        RelayResult relayResult = new RelayResult();
        try {
            Node node = SoapXPathUtil.safeFindSingleNode(sOAPMessage.getSOAPHeader(), "//:MessageProperties");
            String string = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='MessageId']/text()");
            relayResult.setMessageID(string);
            String string2 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='RefToMessageId']/text()");
            relayResult.setRefToMessageID(string2);
            String string3 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='Result']");
            if (!"ERROR".equalsIgnoreCase(string3)) {
                relayResult.setResult(ResultType.RECEIPT);
            } else {
                String string4;
                relayResult.setResult(ResultType.ERROR);
                try {
                    string4 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='ErrorCode']");
                    relayResult.setErrorCode(string4);
                }
                catch (RuntimeException runtimeException) {
                    throw new IllegalStateException("ErrorCode is mandatory for relay result errors.");
                }
                try {
                    string4 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='severity']");
                    relayResult.setSeverity(string4);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                try {
                    string4 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='ShortDescription']");
                    relayResult.setShortDescription(string4);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                try {
                    string4 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='Description']");
                    relayResult.setDescription(string4);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return relayResult;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (SOAPException sOAPException) {
            throw new MEIncomingException("SOAP error", sOAPException);
        }
    }

    public static SubmissionResult soap2SubmissionResult(SOAPMessage sOAPMessage) throws MEIncomingException {
        ValueEnforcer.notNull(sOAPMessage, "SubmissionResult");
        SubmissionResult submissionResult = new SubmissionResult();
        try {
            Node node = SoapXPathUtil.safeFindSingleNode(sOAPMessage.getSOAPHeader(), "//:MessageProperties");
            String string = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='RefToMessageId']/text()");
            submissionResult.setRefToMessageID(string);
            String string2 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='Result']");
            if ("ERROR".equalsIgnoreCase(string2)) {
                submissionResult.setResult(ResultType.ERROR);
                String string3 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='Description']");
                submissionResult.setDescription(string3);
            } else {
                submissionResult.setResult(ResultType.RECEIPT);
                String string4 = SoapXPathUtil.getSingleNodeTextContent(node, ".//:Property[@name='MessageId']/text()");
                submissionResult.setMessageID(string4);
            }
            return submissionResult;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new MEIncomingException("SOAP error", exception);
        }
    }

    @Nonnull
    private static String _getCN(@Nonnull String string) {
        try {
            for (Rdn rdn : new LdapName(string).getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                return (String)rdn.getValue();
            }
            throw new IllegalStateException("Failed to get CN from '" + string + "'");
        }
        catch (InvalidNameException invalidNameException) {
            throw new IllegalStateException("Failed to get CN from '" + string + "'", invalidNameException);
        }
    }

    static SubmissionMessageProperties inferSubmissionData(IMERoutingInformation iMERoutingInformation) throws MEOutgoingException {
        X509Certificate x509Certificate = iMERoutingInformation.getCertificate();
        ValueEnforcer.notNull(x509Certificate, "Endpoint Certificate");
        SubmissionMessageProperties submissionMessageProperties = new SubmissionMessageProperties();
        submissionMessageProperties.messageId = EBMSUtils.genereateEbmsMessageId("message-exchange.toop.eu");
        submissionMessageProperties.action = iMERoutingInformation.getDocumentTypeID().getURIEncoded();
        submissionMessageProperties.service = iMERoutingInformation.getProcessID().getValue();
        submissionMessageProperties.serviceType = iMERoutingInformation.getProcessID().getScheme();
        submissionMessageProperties.toPartyId = EBMSUtils._getCN(iMERoutingInformation.getCertificate().getSubjectX500Principal().getName());
        submissionMessageProperties.conversationId = "1";
        submissionMessageProperties.toPartyRole = "http://www.toop.eu/edelivery/gateway";
        submissionMessageProperties.targetURL = iMERoutingInformation.getEndpointURL();
        submissionMessageProperties.senderId = iMERoutingInformation.getSenderID();
        submissionMessageProperties.receiverId = iMERoutingInformation.getReceiverID();
        try {
            byte[] byArray = iMERoutingInformation.getCertificate().getEncoded();
            submissionMessageProperties.toPartyCertificate = DatatypeConverter.printBase64Binary(byArray);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new MEOutgoingException("Certificate interpreation error", (Throwable)certificateEncodingException);
        }
        return submissionMessageProperties;
    }

    public static void sendSOAPMessage(@Nonnull SOAPMessage sOAPMessage, @Nonnull URL uRL) throws MEOutgoingException {
        SOAPMessage sOAPMessage2;
        ValueEnforcer.notNull(sOAPMessage, "SOAP Message");
        ValueEnforcer.notNull(uRL, "Target url");
        if (LOG.isTraceEnabled()) {
            LOG.trace(SoapUtil.describe(sOAPMessage));
        }
        if ((sOAPMessage2 = SoapUtil.sendSOAPMessage(sOAPMessage, uRL)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(SoapUtil.describe(sOAPMessage2));
            }
            EBMSUtils.validateReceipt(sOAPMessage2);
        }
    }

    private static void validateReceipt(@Nonnull SOAPMessage sOAPMessage) throws MEOutgoingException {
        ValueEnforcer.notNull(sOAPMessage, "Soap message");
        Element element = (Element)SoapXPathUtil.findSingleNode(sOAPMessage.getSOAPPart(), "//:SignalMessage/:Error");
        if (element != null) {
            String string = StringHelper.getNotNull(element.getAttribute("category")).toUpperCase(Locale.US);
            String string2 = StringHelper.getNotNull(element.getAttribute("shortDescription")).toUpperCase(Locale.US);
            String string3 = StringHelper.getNotNull(element.getAttribute("severity")).toUpperCase(Locale.US);
            String string4 = StringHelper.getNotNull(element.getAttribute("errorCode")).toUpperCase(Locale.US);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("EBMS ERROR CODE: [" + string4 + "]\n");
            stringBuilder.append("Severity: [" + string3 + "]\n");
            stringBuilder.append("Category: [" + string + "]\n");
            stringBuilder.append("ShortDescription: [" + string2 + "]\n");
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> "Error from AS4 transmission: EToopErrorCode.ME_002 -- " + stringBuilder.toString());
            throw new MEOutgoingException((IToopErrorCode)EToopErrorCode.ME_002, stringBuilder.toString());
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "AS4 transmission seemed to have worked out fine");
    }

    public static String getMessageId(SOAPMessage sOAPMessage) throws MEIncomingException {
        try {
            return SoapXPathUtil.getSingleNodeTextContent(sOAPMessage.getSOAPHeader(), "//:MessageInfo/:MessageId");
        }
        catch (SOAPException sOAPException) {
            throw new MEIncomingException("Failed to find MessageId", sOAPException);
        }
    }
}

