/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.external;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.url.URLHelper;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.incoming.MEIncomingException;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import eu.toop.connector.api.me.outgoing.MEOutgoingException;
import eu.toop.connector.mem.external.EBMSUtils;
import eu.toop.connector.mem.external.ResultType;
import eu.toop.connector.mem.external.SoapUtil;
import eu.toop.connector.mem.external.SoapXPathUtil;
import eu.toop.connector.mem.external.SubmissionMessageProperties;
import eu.toop.connector.mem.external.notifications.IMessageHandler;
import eu.toop.connector.mem.external.notifications.IRelayResultHandler;
import eu.toop.connector.mem.external.notifications.ISubmissionResultHandler;
import eu.toop.connector.mem.external.notifications.InternalRelayResultHandler;
import eu.toop.connector.mem.external.notifications.InternalSubmissionResultHandler;
import eu.toop.connector.mem.external.notifications.RelayResult;
import eu.toop.connector.mem.external.notifications.SubmissionResult;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MEMDelegate
extends AbstractGlobalSingleton {
    private static final Logger LOG = LoggerFactory.getLogger(MEMDelegate.class);
    private final List<IMessageHandler> messageHandlers = new ArrayList<IMessageHandler>();
    private final List<IRelayResultHandler> relayResultHandlers = new ArrayList<IRelayResultHandler>();
    private final List<ISubmissionResultHandler> submissionResultHandlers = new ArrayList<ISubmissionResultHandler>();
    private final InternalRelayResultHandler internalRelayResultHandler = new InternalRelayResultHandler();
    private final InternalSubmissionResultHandler internalSRHandler = new InternalSubmissionResultHandler();

    @UsedViaReflection
    public MEMDelegate() {
        this.relayResultHandlers.add(this.internalRelayResultHandler);
        this.submissionResultHandlers.add(this.internalSRHandler);
    }

    @Nonnull
    public static MEMDelegate getInstance() {
        return MEMDelegate.getGlobalSingleton(MEMDelegate.class);
    }

    public void sendMessage(IMERoutingInformation iMERoutingInformation, MEMessage mEMessage) throws MEOutgoingException {
        String string;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send message called for procid: " + iMERoutingInformation.getProcessID().getURIEncoded() + " docid: " + iMERoutingInformation.getDocumentTypeID().getURIEncoded());
            LOG.debug("Convert gateway routing metadata to submission data");
        }
        SubmissionMessageProperties submissionMessageProperties = EBMSUtils.inferSubmissionData(iMERoutingInformation);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create SOAP Message based on the submission data and the payloads");
        }
        SOAPMessage sOAPMessage = EBMSUtils.convert2MEOutboundAS4Message(submissionMessageProperties, mEMessage);
        if (LOG.isTraceEnabled()) {
            LOG.trace(SoapUtil.describe(sOAPMessage));
        }
        try {
            string = SoapXPathUtil.getSingleNodeTextContent(sOAPMessage.getSOAPHeader(), "//:MessageInfo/:MessageId");
        }
        catch (SOAPException sOAPException) {
            throw new MEOutgoingException("Failed to find MessageId", (Throwable)sOAPException);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("New soap message ID " + string);
            LOG.debug("Send soap message " + string);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\n" + SoapUtil.describe(sOAPMessage));
        }
        EBMSUtils.sendSOAPMessage(sOAPMessage, URLHelper.getAsURL(TCConfig.MEM.getMEMAS4Endpoint()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("SOAP Message " + string + " sent");
        }
        long l = TCConfig.MEM.getGatewayNotificationWaitTimeout();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Wait for SubmissionResult for " + string);
        }
        SubmissionResult submissionResult = (SubmissionResult)this.internalSRHandler.obtainNotification(string, l);
        LOG.info("SubmissionResult " + (Object)((Object)submissionResult.getResult()));
        if (submissionResult.getResult() != ResultType.RECEIPT) {
            if (LOG.isErrorEnabled()) {
                LOG.error("SubmitMessageId: " + submissionResult.getErrorCode());
                LOG.error("C2-C3 MessageId: " + submissionResult.getRefToMessageID());
                LOG.error("ErrorCode: " + submissionResult.getErrorCode());
                LOG.error("Description: " + submissionResult.getDescription());
            }
            String string2 = "Error from AS4 transmission: EToopErrorCode.ME_002 -- EBMS ERROR CODE: [" + submissionResult.getErrorCode() + "]\n";
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> string2);
            throw new MEOutgoingException((IToopErrorCode)EToopErrorCode.ME_002, string2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Wait for RelayResult for " + string);
        }
        RelayResult relayResult = (RelayResult)this.internalRelayResultHandler.obtainNotification(submissionResult.getMessageID(), l);
        if (LOG.isInfoEnabled()) {
            LOG.info("RelayResult " + (Object)((Object)relayResult.getResult()));
        }
        if (relayResult.getResult() != ResultType.RECEIPT) {
            if (LOG.isErrorEnabled()) {
                LOG.error("SubmitMessageId: " + relayResult.getErrorCode());
                LOG.error("C2-C3 MessageId: " + relayResult.getRefToMessageID());
                LOG.error("ErrorCode: " + relayResult.getErrorCode());
                LOG.error("Severity: " + relayResult.getSeverity());
                LOG.error("ShortDescription: " + relayResult.getShortDescription());
                LOG.error("Description: " + relayResult.getDescription());
            }
            String string3 = "Error from AS4 transmission: EBMS ERROR CODE: " + relayResult.getErrorCode() + "\nSeverity: " + relayResult.getSeverity() + "\nShort Description: " + relayResult.getShortDescription();
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> string3);
            if ("EBMS:0301".equals(relayResult.getErrorCode())) {
                throw new MEOutgoingException((IToopErrorCode)EToopErrorCode.ME_003, string3);
            }
            throw new MEOutgoingException((IToopErrorCode)EToopErrorCode.ME_004, string3);
        }
    }

    public void registerMessageHandler(@Nonnull IMessageHandler iMessageHandler) {
        ValueEnforcer.notNull(iMessageHandler, "MessageHandler");
        this.messageHandlers.add(iMessageHandler);
    }

    public void deregisterMessageHandler(@Nonnull IMessageHandler iMessageHandler) {
        ValueEnforcer.notNull(iMessageHandler, "MessageHandler");
        this.messageHandlers.remove(iMessageHandler);
    }

    public void registerNotificationHandler(@Nonnull IRelayResultHandler iRelayResultHandler) {
        ValueEnforcer.notNull(iRelayResultHandler, "NotificationHandler");
        this.relayResultHandlers.add(iRelayResultHandler);
    }

    public void deregisterNotificationHandler(@Nonnull IRelayResultHandler iRelayResultHandler) {
        ValueEnforcer.notNull(iRelayResultHandler, "NotificationHandler");
        this.relayResultHandlers.remove(iRelayResultHandler);
    }

    public void registerSubmissionResultHandler(@Nonnull ISubmissionResultHandler iSubmissionResultHandler) {
        ValueEnforcer.notNull(iSubmissionResultHandler, "SubmissionResultHandler");
        this.submissionResultHandlers.add(iSubmissionResultHandler);
    }

    public void deregisterSubmissionResultHandler(@Nonnull ISubmissionResultHandler iSubmissionResultHandler) {
        ValueEnforcer.notNull(iSubmissionResultHandler, "SubmissionResultHandler");
        this.submissionResultHandlers.remove(iSubmissionResultHandler);
    }

    public void dispatchInboundMessage(@Nonnull SOAPMessage sOAPMessage) throws MEIncomingException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Received a Deliver message\n   Inbound  AS4  Message ID: " + EBMSUtils.getMessageId(sOAPMessage));
        }
        try {
            MEMessage mEMessage = EBMSUtils.soap2MEMessage(sOAPMessage);
            for (IMessageHandler iMessageHandler : this.messageHandlers) {
                iMessageHandler.handleMessage(mEMessage);
            }
        }
        catch (Exception exception) {
            throw new MEIncomingException("Error handling message " + sOAPMessage, exception);
        }
    }

    public void dispatchRelayResult(SOAPMessage sOAPMessage) throws MEIncomingException {
        try {
            RelayResult relayResult = EBMSUtils.soap2RelayResult(sOAPMessage);
            if (LOG.isInfoEnabled()) {
                LOG.info("RelayResult for \n   Outbound AS4  Message ID: " + relayResult.getRefToMessageID() + "\n   MessageID:                " + relayResult.getMessageID());
            }
            for (IRelayResultHandler iRelayResultHandler : this.relayResultHandlers) {
                iRelayResultHandler.handleNotification(relayResult);
            }
        }
        catch (Exception exception) {
            throw new MEIncomingException("Error handling message " + sOAPMessage, exception);
        }
    }

    public void dispatchSubmissionResult(SOAPMessage sOAPMessage) throws MEIncomingException {
        try {
            SubmissionResult submissionResult = EBMSUtils.soap2SubmissionResult(sOAPMessage);
            if (LOG.isInfoEnabled()) {
                LOG.info("SubmissionResult for \n   SubmitMessage Message ID: " + submissionResult.getRefToMessageID() + "\n   Outbound AS4  Message ID: " + submissionResult.getMessageID());
            }
            for (ISubmissionResultHandler iSubmissionResultHandler : this.submissionResultHandlers) {
                iSubmissionResultHandler.handleSubmissionResult(submissionResult);
            }
        }
        catch (Exception exception) {
            throw new MEIncomingException("Error handling message " + sOAPMessage, exception);
        }
    }
}

