/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.external;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.serialize.JsonWriter;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.security.certificate.CertificateHelper;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MEMDumper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MEMDumper.class);

    private MEMDumper() {
    }

    @Nonnull
    private static IJsonObject _asJson(@Nonnull MEMessage mEMessage) {
        JsonObject jsonObject = new JsonObject();
        if (mEMessage.getSenderID() != null) {
            jsonObject.add("sender", mEMessage.getSenderID().getURIEncoded());
        }
        if (mEMessage.getReceiverID() != null) {
            jsonObject.add("receiver", mEMessage.getReceiverID().getURIEncoded());
        }
        if (mEMessage.getDoctypeID() != null) {
            jsonObject.add("doctype", mEMessage.getDoctypeID().getURIEncoded());
        }
        if (mEMessage.getProcessID() != null) {
            jsonObject.add("process", mEMessage.getProcessID().getURIEncoded());
        }
        JsonArray jsonArray = new JsonArray();
        for (MEPayload mEPayload : mEMessage.payloads()) {
            jsonArray.add(new JsonObject().add("mimeType", mEPayload.getMimeTypeString()).add("contentID", mEPayload.getContentID()).add("data", Base64.safeEncodeBytes(mEPayload.getData().bytes())));
        }
        jsonObject.addJson("payloads", jsonArray);
        return jsonObject;
    }

    @Nonnull
    @Nonempty
    private static final File _getTargetFolder(@Nonnull String string) {
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        File file = new File(string, StringHelper.getLeadingZero(localDate.getYear(), 4) + "/" + StringHelper.getLeadingZero(localDate.getMonthValue(), 2) + "/" + StringHelper.getLeadingZero(localDate.getDayOfMonth(), 2));
        FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file);
        return file;
    }

    @Nonnull
    @Nonempty
    private static final String _getFileID() {
        return PDTIOHelper.getCurrentLocalDateTimeForFilename() + "-" + GlobalIDFactory.getNewIntID();
    }

    public static void dumpOutgoingMessage(@Nonnull IMERoutingInformation iMERoutingInformation, @Nonnull MEMessage mEMessage) {
        if (TCConfig.MEM.isMEMOutgoingDumpEnabled()) {
            String string = TCConfig.MEM.getMEMOutgoingDumpPath();
            if (StringHelper.hasText(string)) {
                JsonObject jsonObject = new JsonObject().addJson("routing", new JsonObject().add("sender", iMERoutingInformation.getSenderID().getURIEncoded()).add("receiver", iMERoutingInformation.getReceiverID().getURIEncoded()).add("doctype", iMERoutingInformation.getDocumentTypeID().getURIEncoded()).add("process", iMERoutingInformation.getProcessID().getURIEncoded()).add("transportProtocol", iMERoutingInformation.getTransportProtocol()).add("endpointURL", iMERoutingInformation.getEndpointURL()).add("certificate", CertificateHelper.getPEMEncodedCertificate(iMERoutingInformation.getCertificate()))).addJson("message", MEMDumper._asJson(mEMessage));
                File file = new File(MEMDumper._getTargetFolder(string), "toop-mem-external-outgoing-" + MEMDumper._getFileID() + ".json");
                try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream(file);){
                    new JsonWriter(new JsonWriterSettings().setIndentEnabled(true)).writeToStream(jsonObject, nonBlockingBufferedOutputStream, StandardCharsets.UTF_8);
                    LOGGER.info("Wrote outgoing MEM dump file '" + file.getAbsolutePath() + "'");
                }
                catch (IOException iOException) {
                    LOGGER.error("Error writing to outgoing MEM dump file '" + file.getAbsolutePath() + "'", iOException);
                }
            } else {
                LOGGER.warn("Dumping of outgoing MEM messages is enabled, but no dump path was configured. Not dumping the message.");
            }
        }
    }

    public static void dumpOutgoingMessage(@Nonnull SOAPMessage sOAPMessage) {
        if (TCConfig.MEM.isMEMOutgoingDumpEnabled()) {
            String string = TCConfig.MEM.getMEMOutgoingDumpPath();
            if (StringHelper.hasText(string)) {
                try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
                    sOAPMessage.writeTo(nonBlockingByteArrayOutputStream);
                    File file = new File(MEMDumper._getTargetFolder(string), "toop-mem-external-outgoing-" + MEMDumper._getFileID() + ".raw");
                    if (SimpleFileIO.writeFile(file, nonBlockingByteArrayOutputStream.toByteArray()).isSuccess()) {
                        LOGGER.info("Wrote outgoing MEM dump file '" + file.getAbsolutePath() + "'");
                    } else {
                        LOGGER.error("Error writing to outgoing MEM dump file '" + file.getAbsolutePath() + "'");
                    }
                }
                catch (IOException | SOAPException exception) {
                    LOGGER.error("Error dumping outgoing SOAP message", exception);
                }
            } else {
                LOGGER.warn("Dumping of outgoing MEM messages is enabled, but no dump path was configured. Not dumping the message.");
            }
        }
    }

    public static void dumpIncomingMessage(@Nonnull byte[] byArray) {
        if (TCConfig.MEM.isMEMIncomingDumpEnabled()) {
            String string = TCConfig.MEM.getMEMIncomingDumpPath();
            if (StringHelper.hasText(string)) {
                String string2 = "toop-mem-external-incoming-" + MEMDumper._getFileID() + ".raw";
                File file = new File(MEMDumper._getTargetFolder(string), string2);
                if (SimpleFileIO.writeFile(file, byArray).isSuccess()) {
                    LOGGER.info("Wrote incoming MEM dump file '" + file.getAbsolutePath() + "'");
                } else {
                    LOGGER.error("Error writing to incoming MEM dump file '" + file.getAbsolutePath() + "'");
                }
            } else {
                LOGGER.warn("Dumping of incoming MEM messages is enabled, but no dump path was configured. Not dumping the message.");
            }
        }
    }
}

