/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.external;

import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import eu.toop.connector.api.me.outgoing.MEOutgoingException;
import eu.toop.connector.mem.external.MEMDumper;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class SoapUtil {
    private static final MessageFactory messageFactory;
    private static final SOAPConnectionFactory soapConnectionFactory;
    private static final DocumentBuilderFactory factory;
    private static final Transformer serializer;

    private SoapUtil() {
    }

    public static SOAPMessage createEmptyMessage() throws MEOutgoingException {
        try {
            return messageFactory.createMessage();
        }
        catch (SOAPException sOAPException) {
            throw new MEOutgoingException("Failed to create new SOAP message", (Throwable)sOAPException);
        }
    }

    public static SOAPMessage sendSOAPMessage(SOAPMessage sOAPMessage, URL uRL) throws MEOutgoingException {
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "Sending AS4 SOAP message to " + uRL.toExternalForm());
        MEMDumper.dumpOutgoingMessage(sOAPMessage);
        try {
            SOAPConnection sOAPConnection = soapConnectionFactory.createConnection();
            return sOAPConnection.call(sOAPMessage, uRL);
        }
        catch (SOAPException sOAPException) {
            throw new MEOutgoingException((IToopErrorCode)EToopErrorCode.ME_001, (Throwable)sOAPException);
        }
    }

    public static SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream) throws IOException, SOAPException {
        return messageFactory.createMessage(mimeHeaders, inputStream);
    }

    public static String describe(SOAPMessage sOAPMessage) {
        StringBuilder stringBuilder = new StringBuilder();
        sOAPMessage.getAttachments().forEachRemaining(object -> {
            AttachmentPart attachmentPart = (AttachmentPart)object;
            stringBuilder.append("ID: ").append(attachmentPart.getContentId()).append("\n");
            stringBuilder.append("   TYPE: ").append(attachmentPart.getContentType()).append("\n");
            try {
                stringBuilder.append("   LEN: ").append(attachmentPart.getRawContentBytes().length).append("\n");
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        });
        return SoapUtil.prettyPrint(sOAPMessage.getSOAPPart()) + "\n\n" + stringBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String prettyPrint(Node node) {
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(nonBlockingByteArrayOutputStream);
            serializer.transform(dOMSource, streamResult);
            serializer.reset();
            String string = nonBlockingByteArrayOutputStream.getAsString(StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception exception) {
            return node.getTextContent();
        }
    }

    static {
        factory = DocumentBuilderFactory.newInstance();
        try {
            messageFactory = MessageFactory.newInstance("SOAP 1.2 Protocol");
            soapConnectionFactory = SOAPConnectionFactory.newInstance();
            serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to initialize factories", exception);
        }
        factory.setNamespaceAware(true);
    }
}

