/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.external;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.xpath.XPathHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class SoapXPathUtil {
    private SoapXPathUtil() {
    }

    @Nonnull
    @ReturnsMutableCopy
    private static XPath createXPath() {
        XPath xPath = XPathHelper.createNewXPath();
        MapBasedNamespaceContext mapBasedNamespaceContext = new MapBasedNamespaceContext();
        mapBasedNamespaceContext.addDefaultNamespaceURI("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/");
        xPath.setNamespaceContext(mapBasedNamespaceContext);
        return xPath;
    }

    @Nullable
    public static Node findSingleNode(@Nonnull Node node, @Nonnull String string) {
        try {
            return (Node)SoapXPathUtil.createXPath().evaluate(string, node, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }

    @Nonnull
    public static Node safeFindSingleNode(@Nonnull Node node, @Nonnull String string) {
        Node node2 = SoapXPathUtil.findSingleNode(node, string);
        if (node2 == null) {
            throw new IllegalArgumentException("No match for [" + string + "]");
        }
        return node2;
    }

    @Nullable
    public static String getSingleNodeTextContent(@Nullable Node node, @Nonnull String string) {
        if (node != null) {
            return SoapXPathUtil.safeFindSingleNode(node, string).getTextContent();
        }
        return null;
    }

    @Nonnull
    public static List<Node> listNodes(@Nonnull Node node, @Nonnull String string) {
        try {
            NodeList nodeList = (NodeList)SoapXPathUtil.createXPath().evaluate(string, node, XPathConstants.NODESET);
            if (nodeList == null) {
                throw new IllegalArgumentException("No match for [" + string + "]");
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            return arrayList;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException(xPathExpressionException);
        }
    }
}

