/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.external.notifications;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.wrapper.Wrapper;
import eu.toop.connector.api.me.outgoing.MEOutgoingException;
import eu.toop.connector.mem.external.notifications.Notification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalNotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InternalNotificationHandler.class);
    private final Map<String, Wrapper<Notification>> messageQueue = new HashMap<String, Wrapper<Notification>>();
    private final String targetTypeName;

    public InternalNotificationHandler(Class<? extends Notification> clazz) {
        this.targetTypeName = clazz.getSimpleName();
        Timer timer = new Timer(this.targetTypeName + "-purgatory-timer");
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                InternalNotificationHandler.this.purgeExpiredNotifications();
            }
        }, 300000L, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNotification(Notification notification) {
        Wrapper<Object> wrapper;
        LOG.info("Received a notification " + notification.getMessageID() + "\n\t" + notification.getRefToMessageID());
        Object object = this.messageQueue;
        synchronized (object) {
            String string = notification.getRefToMessageID();
            if (this.messageQueue.containsKey(string)) {
                wrapper = this.messageQueue.get(string);
            } else {
                wrapper = new Wrapper();
                this.messageQueue.put(string, wrapper);
            }
        }
        object = wrapper;
        synchronized (object) {
            wrapper.set(notification);
            wrapper.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification obtainNotification(String string, long l) throws MEOutgoingException {
        ValueEnforcer.isGE0(l, "timeout");
        ValueEnforcer.notNull(string, "MessageId");
        Wrapper<Object> wrapper = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Wait for a " + this.targetTypeName + " with a messageID: " + string);
        }
        Object object = this.messageQueue;
        synchronized (object) {
            if (this.messageQueue.containsKey(string)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("we already have a " + this.targetTypeName + " message for " + string);
                }
                wrapper = this.messageQueue.remove(string);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("We don't have a " + this.targetTypeName + " waiter for " + string + ". Create a waiter for it");
                }
                wrapper = new Wrapper();
                this.messageQueue.put(string, wrapper);
            }
        }
        if (wrapper.get() == null) {
            object = wrapper;
            synchronized (object) {
                try {
                    wrapper.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Wait for message " + string + " was interrupted.");
                    }
                    Thread.currentThread().interrupt();
                    throw new MEOutgoingException("Wait for message " + string + " was interrupted.", (Throwable)interruptedException);
                }
            }
        }
        if (wrapper.get() == null) {
            throw new MEOutgoingException("Couldn't obtain a " + this.targetTypeName + " with a messageID " + string);
        }
        return (Notification)wrapper.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeExpiredNotifications() {
        long l = System.currentTimeMillis();
        Map<String, Wrapper<Notification>> map = this.messageQueue;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, Wrapper<Notification>> object : this.messageQueue.entrySet()) {
                String string = object.getKey();
                Wrapper<Notification> wrapper = object.getValue();
                if (wrapper == null || wrapper.get() == null || !wrapper.get().isExpired(l)) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                this.messageQueue.remove(string);
            }
        }
    }
}

