/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.external.servlet;

import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.CMimeType;
import eu.toop.connector.api.me.incoming.MEIncomingException;
import eu.toop.connector.mem.external.EBMSUtils;
import eu.toop.connector.mem.external.MEMDelegate;
import eu.toop.connector.mem.external.MEMDumper;
import eu.toop.connector.mem.external.SoapUtil;
import eu.toop.connector.mem.external.SoapXPathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/from-as4"})
public class AS4InterfaceServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AS4InterfaceServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        LOG.info("Received a mem 'external' message from the gateway");
        MimeHeaders mimeHeaders = this.readMimeHeaders(httpServletRequest);
        httpServletResponse.setContentType(CMimeType.TEXT_XML.getAsString());
        SOAPMessage sOAPMessage = null;
        try {
            byte[] byArray = StreamHelper.getAllBytes(httpServletRequest.getInputStream());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read inbound message");
            }
            MEMDumper.dumpIncomingMessage(byArray);
            Object object = new NonBlockingByteArrayInputStream(byArray);
            Object object2 = null;
            try {
                sOAPMessage = SoapUtil.createMessage(mimeHeaders, (InputStream)object);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((NonBlockingByteArrayInputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((NonBlockingByteArrayInputStream)object).close();
                    }
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(SoapUtil.describe(sOAPMessage));
            }
            switch (object = SoapXPathUtil.getSingleNodeTextContent(sOAPMessage.getSOAPHeader(), "//:CollaborationInfo/:Action")) {
                case "Deliver": {
                    this.processDelivery(sOAPMessage);
                    break;
                }
                case "Notify": {
                    this.processRelayResult(sOAPMessage);
                    break;
                }
                case "SubmissionResult": {
                    this.processSubmissionResult(sOAPMessage);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Action '" + (String)object + "' is not supported");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Create success receipt");
            }
            object2 = EBMSUtils.createSuccessReceipt(sOAPMessage);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Send success receipt");
            }
            httpServletResponse.setStatus(200);
            httpServletResponse.getOutputStream().write((byte[])object2);
            httpServletResponse.getOutputStream().flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Done processing inbound AS4 message");
            }
        }
        catch (Exception exception) {
            LOG.error("Error processing the message", exception);
            this.sendBackFault(httpServletResponse, sOAPMessage, exception);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("End doPost");
            }
        }
    }

    protected void sendBackFault(HttpServletResponse httpServletResponse, SOAPMessage sOAPMessage, Throwable throwable) throws IOException {
        byte[] byArray;
        LOG.error("Failed to process incoming AS4 message", throwable);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create fault");
        }
        try {
            byArray = EBMSUtils.createFault(sOAPMessage, throwable.getMessage());
        }
        catch (MEIncomingException mEIncomingException) {
            LOG.error("Error in creating fault to send back", mEIncomingException);
            byArray = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write fault to the stream");
        }
        httpServletResponse.setStatus(500);
        httpServletResponse.getOutputStream().write(byArray);
        httpServletResponse.getOutputStream().flush();
    }

    protected void processSubmissionResult(SOAPMessage sOAPMessage) throws MEIncomingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("------->> Received SubmissionResult <<-------");
            LOG.debug("Dispatch SubmissionResult");
            LOG.debug("\n" + SoapUtil.describe(sOAPMessage));
        }
        MEMDelegate.getInstance().dispatchSubmissionResult(sOAPMessage);
    }

    protected void processRelayResult(SOAPMessage sOAPMessage) throws MEIncomingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("------->> Received RelayResult <<-------");
            LOG.debug("Dispatch notification");
            LOG.debug("\n" + SoapUtil.describe(sOAPMessage));
        }
        MEMDelegate.getInstance().dispatchRelayResult(sOAPMessage);
    }

    protected void processDelivery(SOAPMessage sOAPMessage) throws MEIncomingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("------->> Received Delivery <<-------");
            LOG.debug("Dispatch inbound message");
            LOG.debug("\n" + SoapUtil.describe(sOAPMessage));
        }
        MEMDelegate.getInstance().dispatchInboundMessage(sOAPMessage);
    }

    protected MimeHeaders readMimeHeaders(HttpServletRequest httpServletRequest) {
        MimeHeaders mimeHeaders = new MimeHeaders();
        Enumeration<String> enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = httpServletRequest.getHeader(string);
            if (LOG.isDebugEnabled()) {
                LOG.debug("HEADER " + string + " " + string2);
            }
            mimeHeaders.addHeader(string, string2);
        }
        return mimeHeaders;
    }
}

