/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.external.spi;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import eu.toop.connector.api.me.IMessageExchangeSPI;
import eu.toop.connector.api.me.incoming.IMEIncomingHandler;
import eu.toop.connector.api.me.incoming.IncomingEDMErrorResponse;
import eu.toop.connector.api.me.incoming.IncomingEDMRequest;
import eu.toop.connector.api.me.incoming.IncomingEDMResponse;
import eu.toop.connector.api.me.incoming.MEIncomingTransportMetadata;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import eu.toop.connector.api.me.outgoing.MEOutgoingException;
import eu.toop.connector.mem.external.MEMDelegate;
import eu.toop.connector.mem.external.MEMDumper;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.xml.EDMPayloadDeterminator;
import eu.toop.kafkaclient.ToopKafkaClient;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;

@IsSPIImplementation
public class ExternalMessageExchangeSPI
implements IMessageExchangeSPI {
    private IMEIncomingHandler m_aIncomingHandler;

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return "external";
    }

    @Override
    public void registerIncomingHandler(@Nonnull ServletContext servletContext, @Nonnull IMEIncomingHandler iMEIncomingHandler) {
        ValueEnforcer.notNull(servletContext, "ServletContext");
        ValueEnforcer.notNull(iMEIncomingHandler, "IncomingHandler");
        if (this.m_aIncomingHandler != null) {
            throw new IllegalStateException("Another incoming handler was already registered!");
        }
        this.m_aIncomingHandler = iMEIncomingHandler;
        MEMDelegate mEMDelegate = MEMDelegate.getInstance();
        mEMDelegate.registerNotificationHandler(relayResult -> ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "Notification[" + relayResult.getErrorCode() + "]: " + relayResult.getDescription()));
        mEMDelegate.registerSubmissionResultHandler(submissionResult -> ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "SubmissionResult[" + submissionResult.getErrorCode() + "]: " + submissionResult.getDescription()));
        mEMDelegate.registerMessageHandler(mEMessage -> {
            MEPayload mEPayload = mEMessage.payloads().getFirst();
            IEDMTopLevelObject iEDMTopLevelObject = EDMPayloadDeterminator.parseAndFind(mEPayload.getData().getInputStream());
            String string = mEPayload.getContentID();
            MEIncomingTransportMetadata mEIncomingTransportMetadata = new MEIncomingTransportMetadata(mEMessage.getSenderID(), mEMessage.getReceiverID(), mEMessage.getDoctypeID(), mEMessage.getProcessID());
            if (iEDMTopLevelObject instanceof EDMRequest) {
                this.m_aIncomingHandler.handleIncomingRequest(new IncomingEDMRequest((EDMRequest)iEDMTopLevelObject, string, mEIncomingTransportMetadata));
            } else if (iEDMTopLevelObject instanceof EDMResponse) {
                CommonsArrayList<MEPayload> commonsArrayList = new CommonsArrayList<MEPayload>();
                for (MEPayload mEPayload2 : mEMessage.payloads()) {
                    if (mEPayload2 == mEPayload) continue;
                    commonsArrayList.add(mEPayload2);
                }
                this.m_aIncomingHandler.handleIncomingResponse(new IncomingEDMResponse((EDMResponse)iEDMTopLevelObject, string, commonsArrayList, mEIncomingTransportMetadata));
            } else if (iEDMTopLevelObject instanceof EDMErrorResponse) {
                this.m_aIncomingHandler.handleIncomingErrorResponse(new IncomingEDMErrorResponse((EDMErrorResponse)iEDMTopLevelObject, string, mEIncomingTransportMetadata));
            } else {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> "Unsuspported Message: " + iEDMTopLevelObject);
            }
        });
    }

    @Override
    public void sendOutgoing(@Nonnull IMERoutingInformation iMERoutingInformation, @Nonnull MEMessage mEMessage) throws MEOutgoingException {
        MEMDumper.dumpOutgoingMessage(iMERoutingInformation, mEMessage);
        MEMDelegate.getInstance().sendMessage(iMERoutingInformation, mEMessage);
    }

    @Override
    public void shutdown(@Nonnull ServletContext servletContext) {
    }
}

