/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.phase4;

import com.helger.config.IConfig;
import com.helger.phase4.crypto.AS4CryptoFactoryPropertiesFile;
import com.helger.phase4.crypto.AS4CryptoProperties;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.security.keystore.EKeyStoreType;
import eu.toop.connector.api.TCConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Phase4Config {
    private Phase4Config() {
    }

    @Nonnull
    public static IConfig getConfig() {
        return TCConfig.getConfig();
    }

    @Nullable
    public static String getDataPath() {
        return Phase4Config.getConfig().getAsString("phase4.datapath");
    }

    public static boolean isHttpDebugEnabled() {
        return Phase4Config.getConfig().getAsBoolean("phase4.debug.http", false);
    }

    public static boolean isDebugLogIncoming() {
        return Phase4Config.getConfig().getAsBoolean("phase4.debug.incoming", false);
    }

    @Nullable
    public static String getDumpPathIncoming() {
        return Phase4Config.getConfig().getAsString("phase4.dump.incoming.path");
    }

    @Nullable
    public static String getDumpPathOutgoing() {
        return Phase4Config.getConfig().getAsString("phase4.dump.outgoing.path");
    }

    @Nullable
    public static String getFromPartyID() {
        String string = Phase4Config.getConfig().getAsString("phase4.send.fromparty.id");
        if (string == null) {
            string = TCConfig.MEM.getMEMAS4TcPartyid();
        }
        return string;
    }

    @Nullable
    public static String getSendResponseFolderName() {
        return Phase4Config.getConfig().getAsString("phase4.send.response.folder");
    }

    @Nonnull
    public static EKeyStoreType getKeyStoreType() {
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault(Phase4Config.getConfig().getAsString("phase4.keystore.type"), EKeyStoreType.JKS);
    }

    @Nullable
    public static String getKeyStorePath() {
        return Phase4Config.getConfig().getAsString("phase4.keystore.path");
    }

    @Nullable
    public static String getKeyStorePassword() {
        return Phase4Config.getConfig().getAsString("phase4.keystore.password");
    }

    @Nullable
    public static String getKeyStoreKeyAlias() {
        return Phase4Config.getConfig().getAsString("phase4.keystore.key-alias");
    }

    @Nullable
    public static String getKeyStoreKeyPassword() {
        return Phase4Config.getConfig().getAsString("phase4.keystore.key-password");
    }

    @Nonnull
    public static EKeyStoreType getTrustStoreType() {
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault(Phase4Config.getConfig().getAsString("phase4.truststore.type"), EKeyStoreType.JKS);
    }

    @Nullable
    public static String getTrustStorePath() {
        return Phase4Config.getConfig().getAsString("phase4.truststore.path");
    }

    @Nullable
    public static String getTrustStorePassword() {
        return Phase4Config.getConfig().getAsString("phase4.truststore.password");
    }

    @Nonnull
    public static IAS4CryptoFactory getCryptoFactory() {
        return new AS4CryptoFactoryPropertiesFile(new AS4CryptoProperties().setKeyStoreType(Phase4Config.getKeyStoreType()).setKeyStorePath(Phase4Config.getKeyStorePath()).setKeyStorePassword(Phase4Config.getKeyStorePassword()).setKeyAlias(Phase4Config.getKeyStoreKeyAlias()).setKeyPassword(Phase4Config.getKeyStoreKeyPassword()).setTrustStoreType(Phase4Config.getTrustStoreType()).setTrustStorePath(Phase4Config.getTrustStorePath()).setTrustStorePassword(Phase4Config.getTrustStorePassword()));
    }
}

