/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.phase4;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.peppol.utils.PeppolCertificateHelper;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.Phase4OutgoingAttachment;
import com.helger.phase4.cef.Phase4CEFEndpointDetailProviderConstant;
import com.helger.phase4.cef.Phase4CEFSender;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.http.AS4HttpDebug;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.MessageProperty;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.servlet.AS4ServerInitializer;
import com.helger.phase4.servlet.dump.AS4IncomingDumperFileBased;
import com.helger.phase4.servlet.dump.AS4OutgoingDumperFileBased;
import com.helger.phase4.util.Phase4Exception;
import com.helger.photon.app.io.WebFileIO;
import com.helger.servlet.ServletHelper;
import eu.toop.connector.api.http.TCHttpClientSettings;
import eu.toop.connector.api.me.IMessageExchangeSPI;
import eu.toop.connector.api.me.incoming.IMEIncomingHandler;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import eu.toop.connector.api.me.outgoing.MEOutgoingException;
import eu.toop.connector.mem.phase4.Phase4Config;
import eu.toop.connector.mem.phase4.RawResponseWriter;
import eu.toop.connector.mem.phase4.config.TOOPPMode;
import eu.toop.connector.mem.phase4.servlet.AS4MessageProcessorSPI;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import java.io.File;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.naming.InvalidNameException;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IsSPIImplementation
public class Phase4MessageExchangeSPI
implements IMessageExchangeSPI {
    public static final String ID = "phase4";
    private static final Logger LOGGER = LoggerFactory.getLogger(Phase4MessageExchangeSPI.class);
    private final IAS4CryptoFactory m_aCF = Phase4Config.getCryptoFactory();

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return ID;
    }

    @Nonnull
    @Nonempty
    private static final File _getTargetFolder(@Nonnull String string) {
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        File file = new File(string, StringHelper.getLeadingZero(localDate.getYear(), 4) + "/" + StringHelper.getLeadingZero(localDate.getMonthValue(), 2) + "/" + StringHelper.getLeadingZero(localDate.getDayOfMonth(), 2));
        FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file);
        return file;
    }

    @Override
    public void registerIncomingHandler(@Nonnull ServletContext servletContext, @Nonnull IMEIncomingHandler iMEIncomingHandler) {
        Object object;
        Object object2;
        Object object3;
        ValueEnforcer.notNull(servletContext, "ServletContext");
        ValueEnforcer.notNull(iMEIncomingHandler, "IncomingHandler");
        if (!WebFileIO.isInited()) {
            object3 = ServletHelper.getServletContextBasePath(servletContext);
            object2 = Phase4Config.getDataPath();
            if (StringHelper.hasNoText((String)object2)) {
                throw new InitializationException("No phase4 data path was provided!");
            }
            object = new File((String)object2).getAbsoluteFile();
            WebFileIO.initPaths((File)object, (String)object3, false);
        }
        if ((object3 = this.m_aCF.getKeyStore()) == null) {
            throw new InitializationException("Failed to load configured phase4 keystore");
        }
        object2 = this.m_aCF.getPrivateKeyEntry();
        if (object2 == null) {
            throw new InitializationException("Failed to load configured phase4 key");
        }
        LOGGER.info("Verified that the phase4 keystore configuration can be loaded");
        AS4ServerInitializer.initAS4Server();
        object3 = MetaAS4Manager.getPModeMgr();
        object2 = TOOPPMode.createTOOPMode("AnyInitiatorID", "AnyResponderID", "AnyResponderAddress", (string, string2) -> "TOOP_PMODE", false);
        ((PMode)object2).setPayloadService(new PModePayloadService(EAS4CompressionMode.GZIP));
        ((PMode)object2).getReceptionAwareness().setRetry(false);
        object3.createOrUpdatePMode((PMode)object2);
        AS4MessageProcessorSPI.setIncomingHandler(iMEIncomingHandler);
        AS4HttpDebug.setEnabled(Phase4Config.isHttpDebugEnabled());
        object2 = Phase4Config.getDumpPathIncoming();
        if (StringHelper.hasText((String)object2)) {
            LOGGER.info("Dumping incoming phase4 AS4 messages to '" + (String)object2 + "'");
            AS4DumpManager.setIncomingDumper(new AS4IncomingDumperFileBased((arg_0, arg_1) -> Phase4MessageExchangeSPI.lambda$registerIncomingHandler$0((String)object2, arg_0, arg_1)));
        }
        if (StringHelper.hasText((String)(object = Phase4Config.getDumpPathOutgoing()))) {
            LOGGER.info("Dumping outgoing phase4 AS4 messages to '" + (String)object + "'");
            AS4DumpManager.setOutgoingDumper(new AS4OutgoingDumperFileBased((arg_0, arg_1) -> Phase4MessageExchangeSPI.lambda$registerIncomingHandler$1((String)object, arg_0, arg_1)));
        }
    }

    private static void _sendOutgoing(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IMERoutingInformation iMERoutingInformation, @Nonnull MEMessage mEMessage) throws MEOutgoingException {
        try {
            X509Certificate x509Certificate = iMERoutingInformation.getCertificate();
            Phase4CEFSender.CEFUserMessageBuilder cEFUserMessageBuilder = (Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)((Phase4CEFSender.CEFUserMessageBuilder)new Phase4CEFSender.CEFUserMessageBuilder(){

                @Override
                protected void customizeBeforeSending() throws Phase4Exception {
                    this.addMessageProperty(MessageProperty.builder().name("originalSender").value(this.m_aSenderID.getURIEncoded()));
                    this.addMessageProperty(MessageProperty.builder().name("finalRecipient").value(this.m_aReceiverID.getURIEncoded()));
                }
            }.httpClientFactory(new TCHttpClientSettings())).cryptoFactory(iAS4CryptoFactory)).senderParticipantID(iMERoutingInformation.getSenderID())).receiverParticipantID(iMERoutingInformation.getReceiverID())).documentTypeID(iMERoutingInformation.getDocumentTypeID())).processID(iMERoutingInformation.getProcessID())).conversationID(MessageHelperMethods.createRandomConversationID())).fromPartyIDType(null)).fromPartyID(Phase4Config.getFromPartyID())).fromRole("http://www.toop.eu/edelivery/gateway")).toPartyIDType(null)).toPartyID(PeppolCertificateHelper.getCN(x509Certificate.getSubjectX500Principal().getName()))).toRole("http://www.toop.eu/edelivery/gateway")).rawResponseConsumer(new RawResponseWriter())).endpointDetailProvider(new Phase4CEFEndpointDetailProviderConstant(iMERoutingInformation.getCertificate(), iMERoutingInformation.getEndpointURL()));
            int n = 0;
            for (MEPayload mEPayload : mEMessage.payloads()) {
                Phase4OutgoingAttachment phase4OutgoingAttachment = Phase4OutgoingAttachment.builder().data(mEPayload.getData()).contentID(mEPayload.getContentID()).mimeType(mEPayload.getMimeType()).compression(mEPayload.getMimeType().getContentType() == EMimeContentType.TEXT ? EAS4CompressionMode.GZIP : null).build();
                if (n == 0) {
                    cEFUserMessageBuilder.payload(phase4OutgoingAttachment);
                } else {
                    cEFUserMessageBuilder.addAttachment(phase4OutgoingAttachment);
                }
                ++n;
            }
            if (cEFUserMessageBuilder.sendMessage().isSuccess()) {
                LOGGER.info("[phase4] Sucessfully sent message");
            } else {
                LOGGER.error("[phase4] Failed to send message");
            }
        }
        catch (Phase4Exception | InvalidNameException exception) {
            LOGGER.error("[phase4] Error sending message", exception);
            throw new MEOutgoingException((IToopErrorCode)EToopErrorCode.ME_001, (Throwable)exception);
        }
    }

    @Override
    public void sendOutgoing(@Nonnull IMERoutingInformation iMERoutingInformation, @Nonnull MEMessage mEMessage) throws MEOutgoingException {
        LOGGER.info("[phase4] sendOutgoing");
        Phase4MessageExchangeSPI._sendOutgoing(this.m_aCF, iMERoutingInformation, mEMessage);
    }

    @Override
    public void shutdown(@Nonnull ServletContext servletContext) {
    }

    public String toString() {
        return new ToStringGenerator(this).append("CryptoFactory", this.m_aCF).getToString();
    }

    private static /* synthetic */ File lambda$registerIncomingHandler$1(String string, String string2, int n) {
        return new File(Phase4MessageExchangeSPI._getTargetFolder(string), AS4OutgoingDumperFileBased.IFileProvider.getFilename(string2, n));
    }

    private static /* synthetic */ File lambda$registerIncomingHandler$0(String string, IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, HttpHeaderMap httpHeaderMap) {
        return new File(Phase4MessageExchangeSPI._getTargetFolder(string), AS4IncomingDumperFileBased.IFileProvider.getFilename(iAS4IncomingMessageMetadata));
    }

    static {
        SystemProperties.setPropertyValue("phase4.manager.inmemory", true);
    }
}

