/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.phase4;

import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.client.IAS4RawResponseConsumer;
import com.helger.phase4.util.Phase4Exception;
import eu.toop.connector.mem.phase4.Phase4Config;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawResponseWriter
implements IAS4RawResponseConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawResponseWriter.class);

    @Override
    public void handleResponse(AS4ClientSentMessage<byte[]> aS4ClientSentMessage) throws Phase4Exception {
        String string = Phase4Config.getSendResponseFolderName();
        if (StringHelper.hasText(string)) {
            String string2 = aS4ClientSentMessage.getMessageID();
            String string3 = PDTIOHelper.getCurrentLocalDateTimeForFilename() + "-" + FilenameHelper.getAsSecureValidASCIIFilename(string2) + "-response.xml";
            File file = new File(string, string3);
            if (SimpleFileIO.writeFile(file, aS4ClientSentMessage.getResponse()).isSuccess()) {
                LOGGER.info("[phase4] Response file was written to '" + file.getAbsolutePath() + "'");
            } else {
                LOGGER.error("[phase4] Error writing response file to '" + file.getAbsolutePath() + "'");
            }
        }
    }
}

