/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.phase4.config;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.state.ETriState;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.pmode.IPModeIDProvider;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeParty;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformation;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandling;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import com.helger.phase4.wss.EWSSVersion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TOOPPMode {
    private static final String DEFAULT_AGREEMENT_ID = "urn:as4:agreement";

    private TOOPPMode() {
    }

    @Nonnull
    private static PModeLegSecurity _generatePModeLegSecurity() {
        PModeLegSecurity pModeLegSecurity = new PModeLegSecurity();
        pModeLegSecurity.setWSSVersion(EWSSVersion.WSS_111);
        pModeLegSecurity.setX509SignatureAlgorithm(ECryptoAlgorithmSign.RSA_SHA_256);
        pModeLegSecurity.setX509SignatureHashFunction(ECryptoAlgorithmSignDigest.DIGEST_SHA_256);
        pModeLegSecurity.setX509EncryptionAlgorithm(ECryptoAlgorithmCrypt.AES_128_GCM);
        pModeLegSecurity.setX509EncryptionMinimumStrength(128);
        pModeLegSecurity.setPModeAuthorize(false);
        pModeLegSecurity.setSendReceipt(true);
        pModeLegSecurity.setSendReceiptNonRepudiation(true);
        pModeLegSecurity.setSendReceiptReplyPattern(EPModeSendReceiptReplyPattern.RESPONSE);
        return pModeLegSecurity;
    }

    @Nonnull
    public static PMode createTOOPMode(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnull IPModeIDProvider iPModeIDProvider, boolean bl) {
        PModeParty pModeParty = PModeParty.createSimple(string, "http://www.toop.eu/edelivery/gateway");
        PModeParty pModeParty2 = PModeParty.createSimple(string2, "http://www.toop.eu/edelivery/gateway");
        PMode pMode = new PMode(iPModeIDProvider, pModeParty, pModeParty2, DEFAULT_AGREEMENT_ID, EMEP.ONE_WAY, EMEPBinding.PUSH, new PModeLeg(PModeLegProtocol.createForDefaultSoapVersion(string3), new PModeLegBusinessInformation(null, null, null, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultMPC"), new PModeLegErrorHandling(null, null, ETriState.TRUE, ETriState.TRUE, ETriState.UNDEFINED, ETriState.TRUE), null, TOOPPMode._generatePModeLegSecurity()), (PModeLeg)null, (PModePayloadService)null, PModeReceptionAwareness.createDefault());
        if (bl) {
            MetaAS4Manager.getPModeMgr().createOrUpdatePMode(pMode);
        }
        return pMode;
    }
}

