/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.mem.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.servlet.IAS4MessageState;
import com.helger.phase4.servlet.spi.AS4MessageProcessorResult;
import com.helger.phase4.servlet.spi.AS4SignalMessageProcessorResult;
import com.helger.phase4.servlet.spi.IAS4ServletMessageProcessorSPI;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.incoming.IMEIncomingHandler;
import eu.toop.connector.api.me.incoming.IncomingEDMErrorResponse;
import eu.toop.connector.api.me.incoming.IncomingEDMRequest;
import eu.toop.connector.api.me.incoming.IncomingEDMResponse;
import eu.toop.connector.api.me.incoming.MEIncomingTransportMetadata;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.mem.phase4.Phase4Config;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.xml.EDMPayloadDeterminator;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@IsSPIImplementation
public class AS4MessageProcessorSPI
implements IAS4ServletMessageProcessorSPI {
    public static final String ACTION_FAILURE = "Failure";
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4MessageProcessorSPI.class);
    private static IMEIncomingHandler s_aIncomingHandler;

    public static void setIncomingHandler(@Nonnull IMEIncomingHandler iMEIncomingHandler) {
        ValueEnforcer.notNull(iMEIncomingHandler, "IncomingHandler");
        ValueEnforcer.isNull((Object)s_aIncomingHandler, "s_aIncomingHandler");
        s_aIncomingHandler = iMEIncomingHandler;
    }

    @Nullable
    private static IParticipantIdentifier _asPI(@Nullable Ebms3Property ebms3Property) {
        if (ebms3Property == null) {
            return null;
        }
        IIdentifierFactory iIdentifierFactory = TCConfig.getIdentifierFactory();
        String string = ebms3Property.getType();
        String string2 = ebms3Property.getValue();
        if (string == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The particpant identifier is provided without a 'type' attribute: '" + string2 + "'");
            }
            return iIdentifierFactory.parseParticipantIdentifier(string2);
        }
        return iIdentifierFactory.createParticipantIdentifier(string, string2);
    }

    @Override
    @Nonnull
    public AS4MessageProcessorResult processAS4UserMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull IPMode iPMode, @Nullable Node node, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) {
        Object throwable;
        Serializable serializable;
        Object exception;
        if (Phase4Config.isDebugLogIncoming() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Received AS4 message:");
            LOGGER.info("  UserMessage: " + ebms3UserMessage);
            LOGGER.info("  Payload: " + (node == null ? "null" : "present"));
            if (iCommonsList != null) {
                LOGGER.info("  Attachments: " + iCommonsList.size());
                for (WSS4JAttachment object3 : iCommonsList) {
                    LOGGER.info("    Attachment Content Type: " + object3.getMimeType());
                    if (!object3.getMimeType().startsWith("text") && !object3.getMimeType().endsWith("/xml")) continue;
                    try {
                        exception = object3.getSourceStream();
                        serializable = null;
                        try {
                            LOGGER.info("    Attachment Stream Class: " + exception.getClass().getName());
                            throwable = StreamHelper.getAllBytesAsString(object3.getSourceStream(), object3.getCharset());
                            LOGGER.info("    Attachment Content: " + ((String)throwable).length() + " chars");
                        }
                        catch (Throwable throwable2) {
                            serializable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (exception == null) continue;
                            if (serializable != null) {
                                try {
                                    ((InputStream)exception).close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)serializable).addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((InputStream)exception).close();
                        }
                    }
                    catch (Exception exception2) {
                        LOGGER.warn("    Attachment Content: CANNOT BE READ", exception2);
                    }
                }
            }
        }
        if (iCommonsList != null && iCommonsList.isNotEmpty()) {
            WSS4JAttachment wSS4JAttachment = iCommonsList.getFirst();
            try {
                IIdentifierFactory aS4DecompressException = TCConfig.getIdentifierFactory();
                exception = new CommonsArrayList<List<Ebms3Property>>(ebms3UserMessage.getMessageProperties().getProperty());
                serializable = exception.findFirst(ebms3Property -> ebms3Property.getName().equals("originalSender"));
                throwable = exception.findFirst(ebms3Property -> ebms3Property.getName().equals("finalRecipient"));
                MEIncomingTransportMetadata mEIncomingTransportMetadata = new MEIncomingTransportMetadata(AS4MessageProcessorSPI._asPI((Ebms3Property)serializable), AS4MessageProcessorSPI._asPI((Ebms3Property)throwable), aS4DecompressException.parseDocumentTypeIdentifier(ebms3UserMessage.getCollaborationInfo().getAction()), aS4DecompressException.createProcessIdentifier(ebms3UserMessage.getCollaborationInfo().getService().getType(), ebms3UserMessage.getCollaborationInfo().getService().getValue()));
                LOGGER.info("Incoming Transport Metadata: " + mEIncomingTransportMetadata.toString());
                String string = wSS4JAttachment.getId();
                IEDMTopLevelObject iEDMTopLevelObject = EDMPayloadDeterminator.parseAndFind(wSS4JAttachment.getSourceStream());
                if (iEDMTopLevelObject instanceof EDMRequest) {
                    s_aIncomingHandler.handleIncomingRequest(new IncomingEDMRequest((EDMRequest)iEDMTopLevelObject, string, mEIncomingTransportMetadata));
                } else if (iEDMTopLevelObject instanceof EDMResponse) {
                    CommonsArrayList<MEPayload> commonsArrayList = new CommonsArrayList<MEPayload>();
                    for (WSS4JAttachment wSS4JAttachment2 : iCommonsList) {
                        if (wSS4JAttachment2 == wSS4JAttachment) continue;
                        commonsArrayList.add(MEPayload.builder().mimeType(MimeTypeParser.safeParseMimeType(wSS4JAttachment2.getMimeType())).contentID(wSS4JAttachment2.getId()).data(StreamHelper.getAllBytes(wSS4JAttachment2.getSourceStream())).build());
                    }
                    s_aIncomingHandler.handleIncomingResponse(new IncomingEDMResponse((EDMResponse)iEDMTopLevelObject, string, commonsArrayList, mEIncomingTransportMetadata));
                } else if (iEDMTopLevelObject instanceof EDMErrorResponse) {
                    s_aIncomingHandler.handleIncomingErrorResponse(new IncomingEDMErrorResponse((EDMErrorResponse)iEDMTopLevelObject, string, mEIncomingTransportMetadata));
                } else {
                    ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> "Unsuspported Message: " + iEDMTopLevelObject);
                }
            }
            catch (AS4DecompressException exception3) {
                iCommonsList2.add(EEbmsError.EBMS_DECOMPRESSION_FAILURE.getAsEbms3Error(iAS4MessageState.getLocale(), iAS4MessageState.getMessageID(), "Error decompressing a compressed attachment"));
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> "Error handling incoming AS4 message: Error decompressing a compressed attachment");
            }
            catch (Exception exception4) {
                ToopKafkaClient.send(EErrorLevel.ERROR, () -> "Error handling incoming AS4 message", exception4);
            }
        }
        if (ebms3UserMessage.getCollaborationInfo().getAction().equals(ACTION_FAILURE)) {
            return AS4MessageProcessorResult.createFailure(ACTION_FAILURE);
        }
        return AS4MessageProcessorResult.createSuccess();
    }

    @Override
    @Nonnull
    public AS4SignalMessageProcessorResult processAS4SignalMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3SignalMessage ebms3SignalMessage, @Nullable IPMode iPMode, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList) {
        if (ebms3SignalMessage.getReceipt() != null) {
            return AS4SignalMessageProcessorResult.createSuccess();
        }
        if (!ebms3SignalMessage.getError().isEmpty()) {
            return AS4SignalMessageProcessorResult.createSuccess();
        }
        return AS4SignalMessageProcessorResult.createSuccess();
    }
}

