/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.state.EHandled;
import com.helger.commons.string.StringHelper;
import com.helger.photon.api.AbstractAPIExceptionMapper;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import eu.toop.connector.webapi.APIParamException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIExceptionMapper
extends AbstractAPIExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIExceptionMapper.class);

    private static void _logRestException(@Nonnull String string, @Nonnull Throwable throwable) {
        LOGGER.error(string, throwable);
    }

    private static void _setSimpleTextResponse(@Nonnull UnifiedResponse unifiedResponse, int n, @Nullable String string) {
        if (GlobalDebug.isDebugMode()) {
            APIExceptionMapper.setSimpleTextResponse(unifiedResponse, n, string);
            if (StringHelper.hasText(string)) {
                unifiedResponse.disableCaching();
            }
        } else {
            unifiedResponse.setStatus(n);
        }
    }

    @Override
    @Nonnull
    public EHandled applyExceptionOnResponse(@Nonnull InvokableAPIDescriptor invokableAPIDescriptor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse, @Nonnull Throwable throwable) {
        if (throwable instanceof HttpResponseException) {
            APIExceptionMapper._logRestException("HttpResponse exception", throwable);
            HttpResponseException httpResponseException = (HttpResponseException)throwable;
            APIExceptionMapper._setSimpleTextResponse(unifiedResponse, httpResponseException.getStatusCode(), httpResponseException.getReasonPhrase());
            return EHandled.HANDLED;
        }
        if (throwable instanceof APIParamException) {
            APIExceptionMapper._logRestException("Parameter exception", throwable);
            APIExceptionMapper._setSimpleTextResponse(unifiedResponse, 400, GlobalDebug.isDebugMode() ? APIExceptionMapper.getResponseEntityWithStackTrace(throwable) : APIExceptionMapper.getResponseEntityWithoutStackTrace(throwable));
            return EHandled.HANDLED;
        }
        if (throwable instanceof RuntimeException) {
            APIExceptionMapper._logRestException("Runtime exception - " + throwable.getClass().getName(), throwable);
            APIExceptionMapper._setSimpleTextResponse(unifiedResponse, 500, GlobalDebug.isDebugMode() ? APIExceptionMapper.getResponseEntityWithStackTrace(throwable) : APIExceptionMapper.getResponseEntityWithoutStackTrace(throwable));
            return EHandled.HANDLED;
        }
        return EHandled.UNHANDLED;
    }
}

