/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi;

import com.helger.photon.api.APIDescriptor;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.IAPIRegistry;
import eu.toop.connector.webapi.ETCEdmType;
import eu.toop.connector.webapi.as4.ApiPostSend;
import eu.toop.connector.webapi.dsd.ApiGetDsdDpByCountry;
import eu.toop.connector.webapi.smp.ApiGetSmpDocTypes;
import eu.toop.connector.webapi.smp.ApiGetSmpEndpoints;
import eu.toop.connector.webapi.user.ApiPostUserSubmitEdm;
import eu.toop.connector.webapi.validation.ApiPostValidateEdm;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TCAPIInit {
    private TCAPIInit() {
    }

    public static void initAPI(@Nonnull IAPIRegistry iAPIRegistry) {
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.get("/dsd/dp/{datasetType}/by-country/{country}"), ApiGetDsdDpByCountry.class));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.get("/smp/doctypes/{pid}"), ApiGetSmpDocTypes.class));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.get("/smp/endpoints/{pid}/{doctypeid}"), ApiGetSmpEndpoints.class));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.post("/validate/request"), new ApiPostValidateEdm(ETCEdmType.REQUEST)));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.post("/validate/response"), new ApiPostValidateEdm(ETCEdmType.RESPONSE)));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.post("/validate/error"), new ApiPostValidateEdm(ETCEdmType.ERROR_RESPONSE)));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.post("/send"), ApiPostSend.class));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.post("/user/submit/request"), new ApiPostUserSubmitEdm(ETCEdmType.REQUEST)));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.post("/user/submit/response"), new ApiPostUserSubmitEdm(ETCEdmType.RESPONSE)));
        iAPIRegistry.registerAPI(new APIDescriptor(APIPath.post("/user/submit/error"), new ApiPostUserSubmitEdm(ETCEdmType.ERROR_RESPONSE)));
    }
}

