/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.as4;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import eu.toop.connector.api.me.IMessageExchangeSPI;
import eu.toop.connector.api.me.MessageExchangeManager;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.me.outgoing.MERoutingInformation;
import eu.toop.connector.api.rest.TCOutgoingMessage;
import eu.toop.connector.api.rest.TCPayload;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.connector.webapi.APIParamException;
import eu.toop.connector.webapi.helper.AbstractTCAPIInvoker;
import eu.toop.connector.webapi.helper.CommonAPIInvoker;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.annotation.Nonnull;

public class ApiPostSend
extends AbstractTCAPIInvoker {
    @Override
    public IJsonObject invokeAPI(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull Map<String, String> map, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) throws IOException {
        MERoutingInformation mERoutingInformation;
        TCOutgoingMessage tCOutgoingMessage = (TCOutgoingMessage)TCRestJAXB.outgoingMessage().read(iRequestWebScopeWithoutResponse.getRequest().getInputStream());
        if (tCOutgoingMessage == null) {
            throw new APIParamException("Failed to interpret the message body as an 'OutgoingMessage'");
        }
        if (StringHelper.hasNoText(tCOutgoingMessage.getMetadata().getEndpointURL())) {
            throw new APIParamException("The 'OutgoingMessage/Metadata/EndpointURL' element MUST be present and not empty");
        }
        if (ArrayHelper.isEmpty(tCOutgoingMessage.getMetadata().getReceiverCertificate())) {
            throw new APIParamException("The 'OutgoingMessage/Metadata/ReceiverCertificate' element MUST be present and not empty");
        }
        try {
            mERoutingInformation = MERoutingInformation.createFrom(tCOutgoingMessage.getMetadata());
        }
        catch (CertificateException certificateException) {
            throw new APIParamException("Invalid certificate provided: " + certificateException.getMessage());
        }
        MEMessage.Builder builder = MEMessage.builder();
        for (TCPayload tCPayload : tCOutgoingMessage.getPayload()) {
            builder.addPayload(MEPayload.builder().mimeType(MimeTypeParser.parseMimeType(tCPayload.getMimeType())).contentID(StringHelper.getNotEmpty(tCPayload.getContentID(), MEPayload.createRandomContentID())).data(tCPayload.getValue()));
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("senderid", mERoutingInformation.getSenderID().getURIEncoded());
        jsonObject.add("receiverid", mERoutingInformation.getReceiverID().getURIEncoded());
        jsonObject.add("documentTypeID", mERoutingInformation.getDocumentTypeID().getURIEncoded());
        jsonObject.add("processID", mERoutingInformation.getProcessID().getURIEncoded());
        jsonObject.add("transportProfile", mERoutingInformation.getTransportProtocol());
        jsonObject.add("endpointReference", mERoutingInformation.getEndpointURL());
        CommonAPIInvoker.invoke(jsonObject, () -> {
            IMessageExchangeSPI iMessageExchangeSPI = MessageExchangeManager.getConfiguredImplementation();
            iMessageExchangeSPI.sendOutgoing(mERoutingInformation, builder.build());
            jsonObject.add("success", true);
        });
        return jsonObject;
    }
}

