/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.dsd;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import eu.toop.connector.api.dsd.DSDDatasetResponse;
import eu.toop.connector.api.error.ITCErrorHandler;
import eu.toop.connector.webapi.APIParamException;
import eu.toop.connector.webapi.TCAPIConfig;
import eu.toop.connector.webapi.helper.AbstractTCAPIInvoker;
import eu.toop.connector.webapi.helper.CommonAPIInvoker;
import java.util.Map;
import javax.annotation.Nonnull;

public class ApiGetDsdDp
extends AbstractTCAPIInvoker {
    @Override
    public IJsonObject invokeAPI(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull Map<String, String> map, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string2 = map.get("datasetType");
        if (StringHelper.hasNoText(string2)) {
            throw new APIParamException("Missing DatasetType");
        }
        JsonObject jsonObject = new JsonObject();
        CommonAPIInvoker.invoke(jsonObject, () -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            ITCErrorHandler iTCErrorHandler = (eErrorLevel, string, throwable, iToopErrorCode) -> {
                if (eErrorLevel.isError()) {
                    commonsArrayList.add(string);
                }
            };
            ICommonsSet<DSDDatasetResponse> iCommonsSet = TCAPIConfig.getDSDDatasetResponseProvider().getAllDatasetResponses("[api /dsd/dp]", string2, null, iTCErrorHandler);
            if (commonsArrayList.isEmpty()) {
                jsonObject.add("success", true);
                JsonArray jsonArray = new JsonArray();
                for (DSDDatasetResponse dSDDatasetResponse : iCommonsSet) {
                    jsonArray.add(dSDDatasetResponse.getAsJson());
                }
                jsonObject.addJson("dataset-responses", jsonArray);
            } else {
                jsonObject.add("success", false);
                jsonObject.addJson("errors", (IJson)new JsonArray().addAll(commonsArrayList));
            }
        });
        return jsonObject;
    }
}

