/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.helper;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.timing.StopWatch;
import com.helger.json.IJsonObject;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.photon.api.IAPIExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractTCAPIInvoker
implements IAPIExecutor {
    protected static final String JSON_SUCCESS = "success";

    @Nonnull
    public abstract IJsonObject invokeAPI(@Nonnull IAPIDescriptor var1, @Nonnull @Nonempty String var2, @Nonnull Map<String, String> var3, @Nonnull IRequestWebScopeWithoutResponse var4) throws IOException;

    @Override
    public final void invokeAPI(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull Map<String, String> map, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        StopWatch stopWatch = StopWatch.createdStarted();
        IJsonObject iJsonObject = this.invokeAPI(iAPIDescriptor, string, map, iRequestWebScopeWithoutResponse);
        PhotonUnifiedResponse photonUnifiedResponse = (PhotonUnifiedResponse)unifiedResponse;
        photonUnifiedResponse.setJsonWriterSettings(new JsonWriterSettings().setIndentEnabled(true));
        photonUnifiedResponse.json(iJsonObject);
        boolean bl = iJsonObject.getAsBoolean(JSON_SUCCESS, false);
        if (!bl) {
            photonUnifiedResponse.setAllowContentOnStatusCode(true).setStatus(400);
        } else if (iRequestWebScopeWithoutResponse.getHttpMethod() == EHttpMethod.GET) {
            photonUnifiedResponse.enableCaching(10800);
        } else {
            photonUnifiedResponse.disableCaching();
        }
        stopWatch.stop();
        ToopKafkaClient.send((IErrorLevel)(bl ? EErrorLevel.INFO : EErrorLevel.ERROR), () -> "[API] Finished '" + iAPIDescriptor.getPathDescriptor().getAsURLString() + "' after " + stopWatch.getMillis() + " milliseconds with " + (bl ? JSON_SUCCESS : "error"));
    }
}

