/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.helper;

import com.helger.bdve.json.BDVEJsonHelper;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.timing.StopWatch;
import com.helger.json.IJsonObject;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CommonAPIInvoker {
    private CommonAPIInvoker() {
    }

    public static void invoke(@Nonnull IJsonObject iJsonObject, @Nonnull IThrowingRunnable<Exception> iThrowingRunnable) {
        ZonedDateTime zonedDateTime = PDTFactory.getCurrentZonedDateTimeUTC();
        StopWatch stopWatch = StopWatch.createdStarted();
        try {
            iThrowingRunnable.run();
        }
        catch (Exception exception) {
            iJsonObject.add("success", false);
            iJsonObject.addJson("exception", BDVEJsonHelper.getJsonStackTrace(exception));
        }
        stopWatch.stop();
        iJsonObject.add("invocationDateTime", DateTimeFormatter.ISO_ZONED_DATE_TIME.format(zonedDateTime));
        iJsonObject.add("invocationDurationMillis", stopWatch.getMillis());
    }
}

