/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.smp;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.error.LoggingTCErrorHandler;
import eu.toop.connector.webapi.APIParamException;
import eu.toop.connector.webapi.TCAPIConfig;
import eu.toop.connector.webapi.helper.AbstractTCAPIInvoker;
import eu.toop.connector.webapi.helper.CommonAPIInvoker;
import eu.toop.connector.webapi.smp.SMPJsonResponse;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGetSmpDocTypes
extends AbstractTCAPIInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiGetSmpDocTypes.class);

    @Override
    public IJsonObject invokeAPI(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull Map<String, String> map, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string2 = map.get("pid");
        IParticipantIdentifier iParticipantIdentifier = TCConfig.getIdentifierFactory().parseParticipantIdentifier(string2);
        if (iParticipantIdentifier == null) {
            throw new APIParamException("Invalid participant ID '" + string2 + "' provided.");
        }
        LOGGER.info("[API] Document types of '" + iParticipantIdentifier.getURIEncoded() + "' are queried");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("participantID", iParticipantIdentifier.getURIEncoded());
        CommonAPIInvoker.invoke(jsonObject, () -> {
            ICommonsSortedMap<String, String> iCommonsSortedMap = TCAPIConfig.getDDServiceGroupHrefProvider().getAllServiceGroupHrefs(iParticipantIdentifier, LoggingTCErrorHandler.INSTANCE);
            jsonObject.add("success", true);
            jsonObject.addJson("response", SMPJsonResponse.convert(iParticipantIdentifier, iCommonsSortedMap, TCConfig.getIdentifierFactory()));
        });
        return jsonObject;
    }
}

