/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.smp;

import com.helger.commons.annotation.Nonempty;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.webapi.APIParamException;
import eu.toop.connector.webapi.TCAPIConfig;
import eu.toop.connector.webapi.helper.AbstractTCAPIInvoker;
import eu.toop.connector.webapi.helper.CommonAPIInvoker;
import eu.toop.connector.webapi.smp.SMPJsonResponse;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGetSmpEndpoints
extends AbstractTCAPIInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiGetSmpEndpoints.class);

    @Override
    public IJsonObject invokeAPI(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull Map<String, String> map, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string2 = map.get("pid");
        IParticipantIdentifier iParticipantIdentifier = TCConfig.getIdentifierFactory().parseParticipantIdentifier(string2);
        if (iParticipantIdentifier == null) {
            throw new APIParamException("Invalid participant ID '" + string2 + "' provided.");
        }
        String string3 = map.get("doctypeid");
        IDocumentTypeIdentifier iDocumentTypeIdentifier = TCConfig.getIdentifierFactory().parseDocumentTypeIdentifier(string3);
        if (iDocumentTypeIdentifier == null) {
            throw new APIParamException("Invalid document type ID '" + string3 + "' provided.");
        }
        LOGGER.info("[API] Participant information of '" + iParticipantIdentifier.getURIEncoded() + "' is queried for document type '" + iDocumentTypeIdentifier.getURIEncoded() + "'");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("participantID", iParticipantIdentifier.getURIEncoded());
        jsonObject.add("documentTypeID", iDocumentTypeIdentifier.getURIEncoded());
        CommonAPIInvoker.invoke(jsonObject, () -> {
            ServiceMetadataType serviceMetadataType = TCAPIConfig.getDDServiceMetadataProvider().getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
            if (serviceMetadataType != null) {
                jsonObject.add("success", true);
                jsonObject.addJson("response", SMPJsonResponse.convert(iParticipantIdentifier, iDocumentTypeIdentifier, serviceMetadataType));
            } else {
                jsonObject.add("success", false);
            }
        });
        return jsonObject;
    }
}

