/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.smp;

import com.helger.commons.base64.Base64;
import com.helger.commons.datetime.PDTFactory;
import com.helger.datetime.util.PDTXMLConverter;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.peppol.sml.ESMPAPIType;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.bdxr1.utils.BDXR1ExtensionConverter;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ProcessType;
import com.helger.xsds.bdxr.smp1.RedirectType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

@Immutable
public final class SMPJsonResponse {
    public static final String JSON_SMPTYPE = "smptype";
    public static final String JSON_PARTICIPANT_ID = "participantID";
    public static final String JSON_HREF = "href";
    public static final String JSON_DOCUMENT_TYPE_ID = "documentTypeID";
    public static final String JSON_ERROR = "error";
    public static final String JSON_URLS = "urls";
    public static final String JSON_CERTIFICATE_UID = "certificateUID";
    public static final String JSON_REDIRECT = "redirect";
    public static final String JSON_PROCESS_ID = "processID";
    public static final String JSON_TRANSPORT_PROFILE = "transportProfile";
    public static final String JSON_ENDPOINT_REFERENCE = "endpointReference";
    public static final String JSON_REQUIRE_BUSINESS_LEVEL_SIGNATURE = "requireBusinessLevelSignature";
    public static final String JSON_MINIMUM_AUTHENTICATION_LEVEL = "minimumAuthenticationLevel";
    public static final String JSON_SERVICE_ACTIVATION_DATE = "serviceActivationDate";
    public static final String JSON_SERVICE_EXPIRATION_DATE = "serviceExpirationDate";
    public static final String JSON_CERTIFICATE = "certificate";
    public static final String JSON_CERTIFICATE_DETAILS = "certificateDetails";
    public static final String JSON_SERVICE_DESCRIPTION = "serviceDescription";
    public static final String JSON_TECHNICAL_CONTACT_URL = "technicalContactUrl";
    public static final String JSON_TECHNICAL_INFORMATION_URL = "technicalInformationUrl";
    public static final String JSON_ENDPOINTS = "endpoints";
    public static final String JSON_PROCESSES = "processes";
    public static final String JSON_EXTENSION = "extension";
    public static final String JSON_SERVICEINFO = "serviceinfo";

    private SMPJsonResponse() {
    }

    @Nonnull
    public static IJsonObject convert(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull Map<String, String> map, @Nonnull IIdentifierFactory iIdentifierFactory) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(JSON_PARTICIPANT_ID, iParticipantIdentifier.getURIEncoded());
        String string = "/" + iParticipantIdentifier.getURIEncoded() + "/" + "services" + "/";
        JsonArray jsonArray = new JsonArray();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            IJsonObject iJsonObject = new JsonObject().add(JSON_HREF, string3);
            int n = string2.toLowerCase(Locale.US).indexOf(string.toLowerCase(Locale.US));
            if (n >= 0) {
                String string4 = string2.substring(n + string.length());
                iJsonObject.add(JSON_DOCUMENT_TYPE_ID, string4);
                IDocumentTypeIdentifier iDocumentTypeIdentifier = iIdentifierFactory.parseDocumentTypeIdentifier(string4);
                if (iDocumentTypeIdentifier == null) {
                    iJsonObject.add(JSON_ERROR, "The document type ID could not be interpreted as a structured document type!");
                }
            } else {
                iJsonObject.add(JSON_ERROR, "Contained href does not match the rules. Expected path part: '" + string + "'");
            }
            jsonArray.add(iJsonObject);
        }
        jsonObject.addJson(JSON_URLS, jsonArray);
        return jsonObject;
    }

    @Nonnull
    private static IJsonObject _getJsonPrincipal(@Nonnull X500Principal x500Principal) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("name", x500Principal.getName());
        try {
            for (Rdn rdn : new LdapName(x500Principal.getName()).getRdns()) {
                jsonObject.add(rdn.getType(), rdn.getValue());
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return jsonObject;
    }

    @Nullable
    private static String _getLDT(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(localDateTime);
    }

    private static void _convertCertificate(@Nonnull IJsonObject iJsonObject, @Nonnull String string) {
        iJsonObject.add(JSON_CERTIFICATE, string);
        X509Certificate x509Certificate = CertificateHelper.convertStringToCertficateOrNull(string);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("parsable", x509Certificate != null);
        if (x509Certificate != null) {
            jsonObject.addJson("subject", SMPJsonResponse._getJsonPrincipal(x509Certificate.getSubjectX500Principal()));
            jsonObject.addJson("issuer", SMPJsonResponse._getJsonPrincipal(x509Certificate.getIssuerX500Principal()));
            jsonObject.add("serial10", x509Certificate.getSerialNumber());
            jsonObject.add("serial16", x509Certificate.getSerialNumber().toString(16));
            jsonObject.addIfNotNull("notBefore", SMPJsonResponse._getLDT(PDTFactory.createLocalDateTime(x509Certificate.getNotBefore())));
            jsonObject.addIfNotNull("notAfter", SMPJsonResponse._getLDT(PDTFactory.createLocalDateTime(x509Certificate.getNotAfter())));
            jsonObject.add("validByDate", CertificateHelper.isCertificateValidPerNow(x509Certificate));
            jsonObject.add("sigAlgName", x509Certificate.getSigAlgName());
        }
        iJsonObject.addJson(JSON_CERTIFICATE_DETAILS, jsonObject);
    }

    @Nonnull
    public static IJsonObject convert(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull ServiceMetadataType serviceMetadataType) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(JSON_SMPTYPE, ESMPAPIType.OASIS_BDXR_V1.getID());
        jsonObject.add(JSON_PARTICIPANT_ID, iParticipantIdentifier.getURIEncoded());
        jsonObject.add(JSON_DOCUMENT_TYPE_ID, iDocumentTypeIdentifier.getURIEncoded());
        RedirectType redirectType = serviceMetadataType.getRedirect();
        if (redirectType != null) {
            IJsonObject iJsonObject = new JsonObject().add(JSON_HREF, redirectType.getHref()).add(JSON_CERTIFICATE_UID, redirectType.getCertificateUID()).addIfNotNull(JSON_EXTENSION, BDXR1ExtensionConverter.convertToJson(redirectType.getExtension()));
            jsonObject.addJson(JSON_REDIRECT, iJsonObject);
        } else {
            ServiceInformationType serviceInformationType = serviceMetadataType.getServiceInformation();
            JsonObject jsonObject2 = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            if (serviceInformationType.getProcessList() != null) {
                for (ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
                    if (processType.getProcessIdentifier() == null) continue;
                    IJsonObject iJsonObject = new JsonObject().add(JSON_PROCESS_ID, CIdentifier.getURIEncoded(processType.getProcessIdentifier()));
                    JsonArray jsonArray2 = new JsonArray();
                    if (processType.getServiceEndpointList() != null) {
                        for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                            IJsonObject iJsonObject2 = new JsonObject().add(JSON_TRANSPORT_PROFILE, endpointType.getTransportProfile()).add(JSON_ENDPOINT_REFERENCE, endpointType.getEndpointURI()).add(JSON_REQUIRE_BUSINESS_LEVEL_SIGNATURE, endpointType.isRequireBusinessLevelSignature()).add(JSON_MINIMUM_AUTHENTICATION_LEVEL, endpointType.getMinimumAuthenticationLevel());
                            iJsonObject2.addIfNotNull(JSON_SERVICE_ACTIVATION_DATE, SMPJsonResponse._getLDT(PDTXMLConverter.getLocalDateTime(endpointType.getServiceActivationDate())));
                            iJsonObject2.addIfNotNull(JSON_SERVICE_EXPIRATION_DATE, SMPJsonResponse._getLDT(PDTXMLConverter.getLocalDateTime(endpointType.getServiceExpirationDate())));
                            SMPJsonResponse._convertCertificate(iJsonObject2, Base64.encodeBytes(endpointType.getCertificate()));
                            iJsonObject2.add(JSON_SERVICE_DESCRIPTION, endpointType.getServiceDescription()).add(JSON_TECHNICAL_CONTACT_URL, endpointType.getTechnicalContactUrl()).add(JSON_TECHNICAL_INFORMATION_URL, endpointType.getTechnicalInformationUrl()).addIfNotNull(JSON_EXTENSION, BDXR1ExtensionConverter.convertToJson(endpointType.getExtension()));
                            jsonArray2.add(iJsonObject2);
                        }
                    }
                    iJsonObject.addJson(JSON_ENDPOINTS, jsonArray2).addIfNotNull(JSON_EXTENSION, BDXR1ExtensionConverter.convertToJson(processType.getExtension()));
                    jsonArray.add(iJsonObject);
                }
            }
            jsonObject2.addJson(JSON_PROCESSES, jsonArray).addIfNotNull(JSON_EXTENSION, BDXR1ExtensionConverter.convertToJson(serviceInformationType.getExtension()));
            jsonObject.addJson(JSON_SERVICEINFO, jsonObject2);
        }
        return jsonObject;
    }
}

