/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.user;

import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.result.ValidationResult;
import com.helger.bdve.api.result.ValidationResultList;
import com.helger.bdve.json.BDVEJsonHelper;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.commons.timing.StopWatch;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.peppolid.simple.process.SimpleProcessIdentifier;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.security.certificate.CertificateHelper;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ProcessType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import eu.toop.connector.api.me.MessageExchangeManager;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import eu.toop.connector.api.me.outgoing.MERoutingInformation;
import eu.toop.connector.api.me.outgoing.MERoutingInformationInput;
import eu.toop.connector.api.rest.TCOutgoingMessage;
import eu.toop.connector.api.rest.TCPayload;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.connector.app.validation.TCValidator;
import eu.toop.connector.webapi.APIParamException;
import eu.toop.connector.webapi.ETCEdmType;
import eu.toop.connector.webapi.TCAPIConfig;
import eu.toop.connector.webapi.helper.AbstractTCAPIInvoker;
import eu.toop.connector.webapi.helper.CommonAPIInvoker;
import eu.toop.connector.webapi.smp.SMPJsonResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiPostUserSubmitEdm
extends AbstractTCAPIInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiPostUserSubmitEdm.class);
    private final ETCEdmType m_eType;

    public ApiPostUserSubmitEdm(@Nonnull ETCEdmType eTCEdmType) {
        this.m_eType = eTCEdmType;
    }

    @Override
    public IJsonObject invokeAPI(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull Map<String, String> map, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) throws IOException {
        TCOutgoingMessage tCOutgoingMessage = (TCOutgoingMessage)TCRestJAXB.outgoingMessage().read(iRequestWebScopeWithoutResponse.getRequest().getInputStream());
        if (tCOutgoingMessage == null) {
            throw new APIParamException("Failed to interpret the message body as an 'OutgoingMessage'");
        }
        if (StringHelper.hasText(tCOutgoingMessage.getMetadata().getEndpointURL())) {
            throw new APIParamException("The 'OutgoingMessage/Metadata/EndpointURL' element MUST NOT be present");
        }
        if (ArrayHelper.isNotEmpty(tCOutgoingMessage.getMetadata().getReceiverCertificate())) {
            throw new APIParamException("The 'OutgoingMessage/Metadata/ReceiverCertificate' element MUST NOT be present");
        }
        MERoutingInformationInput mERoutingInformationInput = MERoutingInformationInput.createForInput(tCOutgoingMessage.getMetadata());
        Locale locale = Locale.UK;
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("senderid", mERoutingInformationInput.getSenderID().getURIEncoded());
        jsonObject.add("receiverid", mERoutingInformationInput.getReceiverID().getURIEncoded());
        jsonObject.add("documentTypeID", mERoutingInformationInput.getDocumentTypeID().getURIEncoded());
        jsonObject.add("processID", mERoutingInformationInput.getProcessID().getURIEncoded());
        jsonObject.add("transportProfile", mERoutingInformationInput.getTransportProtocol());
        CommonAPIInvoker.invoke(jsonObject, () -> {
            boolean bl = false;
            Object object = StopWatch.createdStarted();
            Object object2 = this.m_eType.getVESID();
            Cloneable cloneable = TCAPIConfig.getVSValidator().validate((VESID)object2, tCOutgoingMessage.getPayloadAtIndex(0).getValue(), locale);
            ((StopWatch)object).stop();
            Serializable serializable = new JsonObject();
            BDVEJsonHelper.applyValidationResultList((IJsonObject)serializable, TCValidator.getVES((VESID)object2), (List<? extends ValidationResult>)((Object)cloneable), locale, ((StopWatch)object).getMillis(), null, null);
            jsonObject.addJson("validation-results", (IJson)serializable);
            boolean bl2 = ((ValidationResultList)cloneable).containsNoError();
            if (bl2) {
                Object object3;
                Object object4;
                object = null;
                object2 = new JsonObject();
                cloneable = TCAPIConfig.getDDServiceMetadataProvider().getServiceMetadata(mERoutingInformationInput.getReceiverID(), mERoutingInformationInput.getDocumentTypeID());
                if (cloneable != null) {
                    object2.addJson("response", SMPJsonResponse.convert(mERoutingInformationInput.getReceiverID(), mERoutingInformationInput.getDocumentTypeID(), (ServiceMetadataType)cloneable));
                    serializable = ((ServiceMetadataType)cloneable).getServiceInformation();
                    if (serializable != null && (object4 = CollectionHelper.findFirst(((ServiceInformationType)serializable).getProcessList().getProcess(), processType -> mERoutingInformationInput.getProcessID().hasSameContent(SimpleProcessIdentifier.wrap(processType.getProcessIdentifier())))) != null && (object3 = CollectionHelper.findFirst(((ProcessType)object4).getServiceEndpointList().getEndpoint(), endpointType -> mERoutingInformationInput.getTransportProtocol().equals(endpointType.getTransportProfile()))) != null) {
                        object2.add("endpointReference", ((EndpointType)object3).getEndpointURI());
                        object = new MERoutingInformation(mERoutingInformationInput, ((EndpointType)object3).getEndpointURI(), CertificateHelper.convertByteArrayToCertficateDirect(((EndpointType)object3).getCertificate()));
                    }
                    if (object == null) {
                        LOGGER.warn("[API] The SMP lookup for '" + mERoutingInformationInput.getReceiverID().getURIEncoded() + "' and '" + mERoutingInformationInput.getDocumentTypeID().getURIEncoded() + "' succeeded, but no endpoint matching '" + mERoutingInformationInput.getProcessID().getURIEncoded() + "' and '" + mERoutingInformationInput.getTransportProtocol() + "' was found.");
                    }
                    object2.add("success", object != null);
                } else {
                    object2.add("success", false);
                }
                jsonObject.addJson("lookup-results", (IJson)object2);
                if (object != null) {
                    serializable = new JsonObject();
                    object4 = MessageExchangeManager.getConfiguredImplementation();
                    object3 = MEMessage.builder();
                    for (TCPayload tCPayload : tCOutgoingMessage.getPayload()) {
                        ((MEMessage.Builder)object3).addPayload(MEPayload.builder().mimeType(MimeTypeParser.parseMimeType(tCPayload.getMimeType())).contentID(StringHelper.getNotEmpty(tCPayload.getContentID(), MEPayload.createRandomContentID())).data(tCPayload.getValue()));
                    }
                    object4.sendOutgoing((IMERoutingInformation)object, ((MEMessage.Builder)object3).build());
                    serializable.add("success", true);
                    jsonObject.addJson("sending-results", (IJson)serializable);
                    bl = true;
                }
                jsonObject.add("success", bl);
            }
        });
        return jsonObject;
    }
}

