/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.webapi.validation;

import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.result.ValidationResultList;
import com.helger.bdve.json.BDVEJsonHelper;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.timing.StopWatch;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import eu.toop.connector.app.validation.TCValidator;
import eu.toop.connector.webapi.ETCEdmType;
import eu.toop.connector.webapi.TCAPIConfig;
import eu.toop.connector.webapi.helper.AbstractTCAPIInvoker;
import eu.toop.connector.webapi.helper.CommonAPIInvoker;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiPostValidateEdm
extends AbstractTCAPIInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiPostValidateEdm.class);
    private final ETCEdmType m_eType;

    public ApiPostValidateEdm(@Nonnull ETCEdmType eTCEdmType) {
        this.m_eType = eTCEdmType;
    }

    @Override
    public IJsonObject invokeAPI(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull Map<String, String> map, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) throws IOException {
        Locale locale = Locale.UK;
        byte[] byArray = StreamHelper.getAllBytes(iRequestWebScopeWithoutResponse.getRequest().getInputStream());
        VESID vESID = this.m_eType.getVESID();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("API validating " + byArray.length + " bytes using '" + vESID.getAsSingleID() + "'");
        }
        JsonObject jsonObject = new JsonObject();
        CommonAPIInvoker.invoke(jsonObject, () -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            ValidationResultList validationResultList = TCAPIConfig.getVSValidator().validate(vESID, byArray, locale);
            stopWatch.stop();
            jsonObject.add("success", true);
            BDVEJsonHelper.applyValidationResultList(jsonObject, TCValidator.getVES(vESID), validationResultList, locale, stopWatch.getMillis(), null, null);
        });
        return jsonObject;
    }
}

