/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.dsd.api.types;

import com.helger.commons.ValueEnforcer;
import eu.toop.dsd.api.types.DoctypeFormatException;
import eu.toop.dsd.api.types.V1DoctypeParts;
import eu.toop.dsd.api.types.V2DoctypeParts;

public abstract class DoctypeParts {
    private String version;

    public String getVersion() {
        return this.version;
    }

    public static DoctypeParts parse(String string) {
        String[] stringArray;
        ValueEnforcer.notEmpty(string, "doctype");
        if (string.startsWith("toop-doctypeid-qns::")) {
            string = string.substring("toop-doctypeid-qns::".length());
        }
        if ((stringArray = string.split("::")).length == 3) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n = string3.indexOf("##");
            if (n == -1) {
                throw new IllegalArgumentException("Invalid doctype " + string);
            }
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 2);
            String string6 = stringArray[2];
            return new V1DoctypeParts(string2, string4, string5, string6);
        }
        if (stringArray.length == 4) {
            String string7 = stringArray[0];
            String string8 = stringArray[1];
            String string9 = stringArray[3];
            String string10 = stringArray[2];
            String string11 = null;
            if (string10.contains("##")) {
                int n = string10.indexOf("##");
                string11 = string10.substring(n + 2);
                string10 = string10.substring(0, n);
            }
            return new V2DoctypeParts(string7, string8, string10, string11, string9);
        }
        throw new DoctypeFormatException("Invalid doctype " + string);
    }

    public abstract boolean matches(String var1);

    public abstract String getDistributionConformsTo();

    public abstract String getDistributionFormat();

    public abstract String getConformsTo();

    public abstract String getDataSetIdentifier();

    public abstract String getDatasetType();
}

