/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.datetime.util.PDTXMLConverter;
import com.helger.jaxb.IJAXBWriter;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.jaxb.cccev.CCCEVConceptType;
import eu.toop.edm.jaxb.cccev.CCCEVRequirementType;
import eu.toop.edm.jaxb.cv.agent.AgentType;
import eu.toop.edm.jaxb.dcatap.DCatAPDistributionType;
import eu.toop.edm.jaxb.w3.cv.ac.CoreBusinessType;
import eu.toop.edm.jaxb.w3.cv.ac.CorePersonType;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.model.BusinessPojo;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.model.DistributionPojo;
import eu.toop.edm.model.EToopLanguageCode;
import eu.toop.edm.model.EToopQueryDefinitionType;
import eu.toop.edm.model.EToopResponseOptionType;
import eu.toop.edm.model.PersonPojo;
import eu.toop.edm.request.EDMRequestPayloadConcepts;
import eu.toop.edm.request.EDMRequestPayloadDistribution;
import eu.toop.edm.request.EDMRequestPayloadDocumentID;
import eu.toop.edm.request.IEDMRequestPayloadProvider;
import eu.toop.edm.slot.SlotAuthorizedRepresentative;
import eu.toop.edm.slot.SlotConsentToken;
import eu.toop.edm.slot.SlotDataConsumer;
import eu.toop.edm.slot.SlotDataSubjectLegalPerson;
import eu.toop.edm.slot.SlotDataSubjectNaturalPerson;
import eu.toop.edm.slot.SlotDatasetIdentifier;
import eu.toop.edm.slot.SlotFullfillingRequirements;
import eu.toop.edm.slot.SlotIssueDateTime;
import eu.toop.edm.slot.SlotProcedure;
import eu.toop.edm.slot.SlotSpecificationIdentifier;
import eu.toop.edm.xml.IJAXBVersatileReader;
import eu.toop.edm.xml.IVersatileWriter;
import eu.toop.edm.xml.JAXBVersatileReader;
import eu.toop.edm.xml.JAXBVersatileWriter;
import eu.toop.edm.xml.cagv.AgentMarshaller;
import eu.toop.edm.xml.cagv.CCAGV;
import eu.toop.edm.xml.cccev.ConceptMarshaller;
import eu.toop.edm.xml.cccev.RequirementMarshaller;
import eu.toop.edm.xml.cv.BusinessMarshaller;
import eu.toop.edm.xml.cv.PersonMarshaller;
import eu.toop.edm.xml.dcatap.DistributionMarshaller;
import eu.toop.regrep.RegRep4Reader;
import eu.toop.regrep.RegRep4Writer;
import eu.toop.regrep.RegRepHelper;
import eu.toop.regrep.query.QueryRequest;
import eu.toop.regrep.query.ResponseOptionType;
import eu.toop.regrep.rim.AnyValueType;
import eu.toop.regrep.rim.CollectionValueType;
import eu.toop.regrep.rim.DateTimeValueType;
import eu.toop.regrep.rim.InternationalStringType;
import eu.toop.regrep.rim.InternationalStringValueType;
import eu.toop.regrep.rim.LocalizedStringType;
import eu.toop.regrep.rim.QueryType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.StringValueType;
import eu.toop.regrep.rim.ValueType;
import eu.toop.regrep.slot.ISlotProvider;
import eu.toop.regrep.slot.SlotHelper;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Node;

public class EDMRequest
implements IEDMTopLevelObject {
    private static final ICommonsOrderedSet<String> TOP_LEVEL_SLOTS = new CommonsLinkedHashSet<String>("SpecificationIdentifier", "IssueDateTime", "Procedure", "FullfillingRequirement", "ConsentToken", "DatasetIdentifier", "DataConsumer");
    private final EToopQueryDefinitionType m_eQueryDefinition;
    private final String m_sRequestID;
    private final EToopResponseOptionType m_eResponseOption;
    private final String m_sSpecificationIdentifier;
    private final LocalDateTime m_aIssueDateTime;
    private final InternationalStringType m_aProcedure;
    private final ICommonsList<CCCEVRequirementType> m_aFullfillingRequirements = new CommonsArrayList<CCCEVRequirementType>();
    private final AgentPojo m_aDataConsumer;
    private final String m_sConsentToken;
    private final String m_sDatasetIdentifier;
    private final BusinessPojo m_aDataSubjectLegalPerson;
    private final PersonPojo m_aDataSubjectNaturalPerson;
    private final PersonPojo m_aAuthorizedRepresentative;
    private final IEDMRequestPayloadProvider m_aPayloadProvider;

    protected EDMRequest(@Nonnull EToopQueryDefinitionType eToopQueryDefinitionType, @Nonnull @Nonempty String string, @Nonnull EToopResponseOptionType eToopResponseOptionType, @Nonnull @Nonempty String string2, @Nonnull LocalDateTime localDateTime, @Nullable InternationalStringType internationalStringType, @Nullable ICommonsList<CCCEVRequirementType> iCommonsList, @Nonnull AgentPojo agentPojo, @Nullable String string3, @Nullable String string4, @Nullable BusinessPojo businessPojo, @Nullable PersonPojo personPojo, @Nullable PersonPojo personPojo2, @Nonnull IEDMRequestPayloadProvider iEDMRequestPayloadProvider) {
        ValueEnforcer.notNull(eToopQueryDefinitionType, "QueryDefinition");
        ValueEnforcer.notNull(eToopResponseOptionType, "ResponseOption");
        ValueEnforcer.notEmpty(string, "RequestID");
        ValueEnforcer.notEmpty(string2, "SpecificationIdentifier");
        ValueEnforcer.notNull(localDateTime, "IssueDateTime");
        ValueEnforcer.noNullValue(iCommonsList, "FullfillingRequirements");
        ValueEnforcer.notNull(agentPojo, "DataConsumer");
        ValueEnforcer.isFalse(businessPojo == null && personPojo == null || businessPojo != null && personPojo != null, "Exactly one DataSubject must be set");
        ValueEnforcer.notNull(iEDMRequestPayloadProvider, "RequestPayloadProvider");
        this.m_eQueryDefinition = eToopQueryDefinitionType;
        this.m_sRequestID = string;
        this.m_eResponseOption = eToopResponseOptionType;
        this.m_sSpecificationIdentifier = string2;
        this.m_aIssueDateTime = localDateTime;
        this.m_aProcedure = internationalStringType;
        if (iCommonsList != null) {
            this.m_aFullfillingRequirements.addAll(iCommonsList);
        }
        this.m_aDataConsumer = agentPojo;
        this.m_sConsentToken = string3;
        this.m_sDatasetIdentifier = string4;
        this.m_aDataSubjectLegalPerson = businessPojo;
        this.m_aDataSubjectNaturalPerson = personPojo;
        this.m_aAuthorizedRepresentative = personPojo2;
        this.m_aPayloadProvider = iEDMRequestPayloadProvider;
    }

    @Nonnull
    public final EToopQueryDefinitionType getQueryDefinition() {
        return this.m_eQueryDefinition;
    }

    @Nonnull
    @Nonempty
    public final String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    public final EToopResponseOptionType getResponseOption() {
        return this.m_eResponseOption;
    }

    @Nonnull
    @Nonempty
    public final String getSpecificationIdentifier() {
        return this.m_sSpecificationIdentifier;
    }

    @Nonnull
    public final LocalDateTime getIssueDateTime() {
        return this.m_aIssueDateTime;
    }

    @Nullable
    public final InternationalStringType getProcedure() {
        return this.m_aProcedure;
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<CCCEVRequirementType> fullfillingRequirements() {
        return this.m_aFullfillingRequirements;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<CCCEVRequirementType> getAllFullfillingRequirements() {
        return (List)this.m_aFullfillingRequirements.getClone();
    }

    @Nonnull
    public final AgentPojo getDataConsumer() {
        return this.m_aDataConsumer;
    }

    @Nullable
    public final String getConsentToken() {
        return this.m_sConsentToken;
    }

    @Nullable
    public final String getDatasetIdentifier() {
        return this.m_sDatasetIdentifier;
    }

    @Nullable
    public final BusinessPojo getDataSubjectLegalPerson() {
        return this.m_aDataSubjectLegalPerson;
    }

    @Nullable
    public final PersonPojo getDataSubjectNaturalPerson() {
        return this.m_aDataSubjectNaturalPerson;
    }

    @Nullable
    public final PersonPojo getAuthorizedRepresentative() {
        return this.m_aAuthorizedRepresentative;
    }

    @Nonnull
    public final IEDMRequestPayloadProvider getPayloadProvider() {
        return this.m_aPayloadProvider;
    }

    @Nonnull
    private QueryRequest _createQueryRequest(@Nonnull ICommonsList<ISlotProvider> iCommonsList) {
        ValueEnforcer.notNull(this.m_eQueryDefinition, "QueryDefinition");
        ValueEnforcer.notEmpty(this.m_sRequestID, "RequestID");
        ValueEnforcer.noNullValue(iCommonsList, "Providers");
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (ISlotProvider object2 : iCommonsList) {
            String string = object2.getName();
            if (commonsLinkedHashMap.containsKey(string)) {
                throw new IllegalArgumentException("A slot provider for name '" + string + "' is already present");
            }
            commonsLinkedHashMap.put(string, object2);
        }
        QueryRequest queryRequest = RegRepHelper.createEmptyQueryRequest();
        queryRequest.setId(this.m_sRequestID);
        queryRequest.getResponseOption().setReturnType(this.m_eResponseOption.getID());
        for (String string : TOP_LEVEL_SLOTS) {
            ISlotProvider iSlotProvider = (ISlotProvider)commonsLinkedHashMap.get(string);
            if (iSlotProvider == null) continue;
            queryRequest.addSlot(iSlotProvider.createSlot());
        }
        QueryType queryType = new QueryType();
        queryType.setQueryDefinition(this.m_eQueryDefinition.getID());
        for (Map.Entry entry : commonsLinkedHashMap.entrySet()) {
            if (TOP_LEVEL_SLOTS.contains(entry.getKey())) continue;
            queryType.addSlot(((ISlotProvider)entry.getValue()).createSlot());
        }
        queryRequest.setQuery(queryType);
        return queryRequest;
    }

    @Nonnull
    public QueryRequest getAsQueryRequest() {
        CommonsArrayList<ISlotProvider> commonsArrayList = new CommonsArrayList<ISlotProvider>();
        if (this.m_sSpecificationIdentifier != null) {
            commonsArrayList.add(new SlotSpecificationIdentifier(this.m_sSpecificationIdentifier));
        }
        if (this.m_aIssueDateTime != null) {
            commonsArrayList.add(new SlotIssueDateTime(this.m_aIssueDateTime));
        }
        if (this.m_aProcedure != null) {
            commonsArrayList.add(new SlotProcedure(this.m_aProcedure));
        }
        if (this.m_aFullfillingRequirements.isNotEmpty()) {
            commonsArrayList.add(new SlotFullfillingRequirements(this.m_aFullfillingRequirements));
        }
        if (this.m_sConsentToken != null) {
            commonsArrayList.add(new SlotConsentToken(this.m_sConsentToken));
        }
        if (this.m_sDatasetIdentifier != null) {
            commonsArrayList.add(new SlotDatasetIdentifier(this.m_sDatasetIdentifier));
        }
        if (this.m_aDataConsumer != null) {
            commonsArrayList.add(new SlotDataConsumer(this.m_aDataConsumer));
        }
        if (this.m_aDataSubjectLegalPerson != null) {
            commonsArrayList.add(new SlotDataSubjectLegalPerson(this.m_aDataSubjectLegalPerson));
        }
        if (this.m_aDataSubjectNaturalPerson != null) {
            commonsArrayList.add(new SlotDataSubjectNaturalPerson(this.m_aDataSubjectNaturalPerson));
        }
        if (this.m_aAuthorizedRepresentative != null) {
            commonsArrayList.add(new SlotAuthorizedRepresentative(this.m_aAuthorizedRepresentative));
        }
        commonsArrayList.add(this.m_aPayloadProvider.getAsSlotProvider());
        return this._createQueryRequest(commonsArrayList);
    }

    @Nonnull
    public IVersatileWriter<QueryRequest> getWriter() {
        return new JAXBVersatileWriter<QueryRequest>(this.getAsQueryRequest(), (IJAXBWriter<QueryRequest>)RegRep4Writer.queryRequest(CCAGV.XSDS).setFormattedOutput(true));
    }

    @Nonnull
    public static IJAXBVersatileReader<EDMRequest> reader() {
        return new JAXBVersatileReader<QueryRequest, EDMRequest>(RegRep4Reader.queryRequest(CCAGV.XSDS), EDMRequest::create);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EDMRequest eDMRequest = (EDMRequest)object;
        return EqualsHelper.equals(this.m_eQueryDefinition, eDMRequest.m_eQueryDefinition) && EqualsHelper.equals(this.m_eResponseOption, eDMRequest.m_eResponseOption) && EqualsHelper.equals(this.m_sRequestID, eDMRequest.m_sRequestID) && EqualsHelper.equals(this.m_sSpecificationIdentifier, eDMRequest.m_sSpecificationIdentifier) && EqualsHelper.equals(this.m_aIssueDateTime, eDMRequest.m_aIssueDateTime) && EqualsHelper.equals(this.m_aProcedure, eDMRequest.m_aProcedure) && EqualsHelper.equals(this.m_aFullfillingRequirements, eDMRequest.m_aFullfillingRequirements) && EqualsHelper.equals(this.m_aDataConsumer, eDMRequest.m_aDataConsumer) && EqualsHelper.equals(this.m_sConsentToken, eDMRequest.m_sConsentToken) && EqualsHelper.equals(this.m_sDatasetIdentifier, eDMRequest.m_sDatasetIdentifier) && EqualsHelper.equals(this.m_aDataSubjectLegalPerson, eDMRequest.m_aDataSubjectLegalPerson) && EqualsHelper.equals(this.m_aDataSubjectNaturalPerson, eDMRequest.m_aDataSubjectNaturalPerson) && EqualsHelper.equals(this.m_aAuthorizedRepresentative, eDMRequest.m_aAuthorizedRepresentative) && EqualsHelper.equals(this.m_aPayloadProvider, eDMRequest.m_aPayloadProvider);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eQueryDefinition)).append((Enum)this.m_eResponseOption)).append(this.m_sRequestID).append(this.m_sSpecificationIdentifier).append(this.m_aIssueDateTime).append(this.m_aProcedure).append(this.m_aFullfillingRequirements)).append(this.m_aDataConsumer).append(this.m_sConsentToken).append(this.m_sDatasetIdentifier).append(this.m_aDataSubjectLegalPerson).append(this.m_aDataSubjectNaturalPerson).append(this.m_aAuthorizedRepresentative).append(this.m_aPayloadProvider).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("QueryDefinition", this.m_eQueryDefinition).append("ResponseOption", this.m_eResponseOption).append("RequestID", this.m_sRequestID).append("SpecificationIdentifier", this.m_sSpecificationIdentifier).append("IssueDateTime", this.m_aIssueDateTime).append("Procedure", this.m_aProcedure).append("FullfillingRequirements", this.m_aFullfillingRequirements).append("DataConsumer", this.m_aDataConsumer).append("ConsentToken", this.m_sConsentToken).append("DatasetIdentifier", this.m_sDatasetIdentifier).append("DataSubjectLegalPerson", this.m_aDataSubjectLegalPerson).append("DataSubjectNaturalPerson", this.m_aDataSubjectNaturalPerson).append("AuthorizedRepresentative", this.m_aAuthorizedRepresentative).append("RequestPayloadProvider", this.m_aPayloadProvider).getToString();
    }

    @Nonnull
    public static BuilderConcept builderConcept() {
        return (BuilderConcept)((BuilderConcept)new BuilderConcept().specificationIdentifier("toop-edm:v2.0")).responseOption(EToopResponseOptionType.INLINE);
    }

    @Nonnull
    public static BuilderDocumentsByDistribution builderDocumentsByDistribution() {
        return (BuilderDocumentsByDistribution)((BuilderDocumentsByDistribution)new BuilderDocumentsByDistribution().specificationIdentifier("toop-edm:v2.0")).responseOption(EToopResponseOptionType.INLINE);
    }

    @Nonnull
    public static BuilderDocumentsByDistribution builderDocumentReferencesByDistribution() {
        return (BuilderDocumentsByDistribution)((BuilderDocumentsByDistribution)new BuilderDocumentsByDistribution().specificationIdentifier("toop-edm:v2.0")).responseOption(EToopResponseOptionType.REFERENCE);
    }

    @Nonnull
    public static BuilderDocumentByID builderDocumentByID() {
        return (BuilderDocumentByID)((BuilderDocumentByID)new BuilderDocumentByID().specificationIdentifier("toop-edm:v2.0")).responseOption(EToopResponseOptionType.INLINE);
    }

    private static void _applySlots(@Nonnull SlotType slotType, @Nonnull AbstractBuilder<?> abstractBuilder) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "SpecificationIdentifier": {
                if (!(valueType instanceof StringValueType)) break;
                String string2 = ((StringValueType)valueType).getValue();
                abstractBuilder.specificationIdentifier(string2);
                break;
            }
            case "IssueDateTime": {
                if (!(valueType instanceof DateTimeValueType)) break;
                XMLGregorianCalendar xMLGregorianCalendar = ((DateTimeValueType)valueType).getValue();
                abstractBuilder.issueDateTime(PDTXMLConverter.getLocalDateTime(xMLGregorianCalendar));
                break;
            }
            case "Procedure": {
                if (!(valueType instanceof InternationalStringValueType)) break;
                InternationalStringType internationalStringType = ((InternationalStringValueType)valueType).getValue();
                abstractBuilder.procedure(internationalStringType);
                break;
            }
            case "FullfillingRequirement": {
                if (!(valueType instanceof CollectionValueType)) break;
                List<ValueType> list = ((CollectionValueType)valueType).getElement();
                for (ValueType valueType2 : list) {
                    Object object;
                    if (!(valueType2 instanceof AnyValueType) || !((object = ((AnyValueType)valueType2).getAny()) instanceof Node)) continue;
                    abstractBuilder.addFullfillingRequirement((CCCEVRequirementType)new RequirementMarshaller().read((Node)object));
                }
                break;
            }
            case "ConsentToken": {
                if (!(valueType instanceof StringValueType)) break;
                String string3 = ((StringValueType)valueType).getValue();
                abstractBuilder.consentToken(string3);
                break;
            }
            case "DatasetIdentifier": {
                if (!(valueType instanceof StringValueType)) break;
                String string4 = ((StringValueType)valueType).getValue();
                abstractBuilder.datasetIdentifier(string4);
                break;
            }
            case "DataConsumer": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.dataConsumer(AgentPojo.builder((AgentType)new AgentMarshaller().read(node)));
                break;
            }
            case "LegalPerson": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.dataSubject(BusinessPojo.builder((CoreBusinessType)new BusinessMarshaller().read(node)));
                break;
            }
            case "NaturalPerson": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.dataSubject(PersonPojo.builder((CorePersonType)new PersonMarshaller().read(node)));
                break;
            }
            case "AuthorizedRepresentative": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                abstractBuilder.authorizedRepresentative(PersonPojo.builder((CorePersonType)new PersonMarshaller().read(node)));
                break;
            }
            case "ConceptRequestList": {
                List<ValueType> list;
                if (!(valueType instanceof CollectionValueType) || (list = ((CollectionValueType)valueType).getElement()).isEmpty()) break;
                for (ValueType valueType3 : list) {
                    Object object;
                    if (!(valueType3 instanceof AnyValueType) || !((object = ((AnyValueType)valueType3).getAny()) instanceof Node)) continue;
                    ((BuilderConcept)abstractBuilder).addConcept((CCCEVConceptType)new ConceptMarshaller().read((Node)object));
                }
                break;
            }
            case "DistributionRequestList": {
                List<ValueType> list;
                if (!(valueType instanceof CollectionValueType) || (list = ((CollectionValueType)valueType).getElement()).isEmpty()) break;
                for (ValueType valueType4 : list) {
                    Object object;
                    if (!(valueType4 instanceof AnyValueType) || !((object = ((AnyValueType)valueType4).getAny()) instanceof Node)) continue;
                    ((BuilderDocumentsByDistribution)abstractBuilder).addDistribution((DCatAPDistributionType)new DistributionMarshaller().read((Node)object));
                }
                break;
            }
            case "id": {
                if (!(valueType instanceof StringValueType)) break;
                String string5 = ((StringValueType)valueType).getValue();
                ((BuilderDocumentByID)abstractBuilder).documentID(string5);
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    @Nonnull
    public static EDMRequest create(@Nonnull QueryRequest queryRequest) {
        AbstractBuilder abstractBuilder;
        ValueEnforcer.notNull(queryRequest, "QueryRequest");
        QueryType queryType = queryRequest.getQuery();
        ValueEnforcer.notNull(queryType, "QueryRequest.Query");
        CommonsHashSet<String> commonsHashSet = new CommonsHashSet<String>(queryType.getSlot(), SlotType::getName);
        if (commonsHashSet.contains("ConceptRequestList")) {
            abstractBuilder = EDMRequest.builderConcept();
        } else if (commonsHashSet.contains("DistributionRequestList")) {
            abstractBuilder = EDMRequest.builderDocumentsByDistribution();
        } else if (commonsHashSet.contains("id")) {
            abstractBuilder = EDMRequest.builderDocumentByID();
        } else {
            throw new IllegalStateException("Cannot read this QueryRequest as a TOOP EDM request");
        }
        abstractBuilder.id(queryRequest.getId());
        for (SlotType iExplicitlyCloneable2 : queryRequest.getSlot()) {
            EDMRequest._applySlots(iExplicitlyCloneable2, abstractBuilder);
        }
        for (SlotType slotType : queryType.getSlot()) {
            if (slotType == null) continue;
            EDMRequest._applySlots(slotType, abstractBuilder);
        }
        Object object = null;
        ResponseOptionType responseOptionType = queryRequest.getResponseOption();
        if (responseOptionType != null && responseOptionType.getReturnType() != null) {
            object = EToopResponseOptionType.getFromIDOrNull(responseOptionType.getReturnType());
        }
        abstractBuilder.responseOption((EToopResponseOptionType)(object != null ? object : EToopResponseOptionType.INLINE));
        return abstractBuilder.build();
    }

    public static class BuilderDocumentByID
    extends AbstractBuilder<BuilderDocumentByID> {
        private String m_sDocumentID;

        protected BuilderDocumentByID() {
            super(EToopQueryDefinitionType.DOCUMENT_BY_ID);
        }

        @Nonnull
        public BuilderDocumentByID documentID(@Nullable String string) {
            this.m_sDocumentID = string;
            return this;
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (this.m_sDocumentID == null) {
                throw new IllegalStateException("A Query Definition of type 'GetObjectByID' must contain a Document ID");
            }
        }

        @Override
        @Nonnull
        public EDMRequest build() {
            this.checkConsistency();
            return new EDMRequest(this.m_eQueryDefinition, this.m_sRequestID, this.m_eResponseOption, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aProcedure, this.m_aFullfillingRequirements, this.m_aDataConsumer, this.m_sConsentToken, this.m_sDatasetIdentifier, this.m_aDataSubjectLegalPerson, this.m_aDataSubjectNaturalPerson, this.m_aAuthorizedRepresentative, new EDMRequestPayloadDocumentID(this.m_sDocumentID));
        }
    }

    public static class BuilderDocumentsByDistribution
    extends AbstractBuilder<BuilderDocumentsByDistribution> {
        private final ICommonsList<DistributionPojo> m_aDistributions = new CommonsArrayList<DistributionPojo>();

        protected BuilderDocumentsByDistribution() {
            super(EToopQueryDefinitionType.DOCUMENT_BY_DISTRIBUTION);
        }

        @Nonnull
        public final BuilderDocumentsByDistribution addDistribution(@Nullable Consumer<? super DistributionPojo.Builder> consumer) {
            if (consumer != null) {
                DistributionPojo.Builder builder = DistributionPojo.builder();
                consumer.accept(builder);
                this.addDistribution(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentsByDistribution addDistribution(@Nullable DCatAPDistributionType dCatAPDistributionType) {
            return this.addDistribution(dCatAPDistributionType == null ? null : DistributionPojo.builder(dCatAPDistributionType));
        }

        @Nonnull
        public BuilderDocumentsByDistribution addDistribution(@Nullable DistributionPojo.Builder builder) {
            return this.addDistribution(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderDocumentsByDistribution addDistribution(@Nullable DistributionPojo distributionPojo) {
            if (distributionPojo != null) {
                this.m_aDistributions.add(distributionPojo);
            }
            return this;
        }

        @Nonnull
        public final BuilderDocumentsByDistribution distribution(@Nullable Consumer<? super DistributionPojo.Builder> consumer) {
            if (consumer != null) {
                DistributionPojo.Builder builder = DistributionPojo.builder();
                consumer.accept(builder);
                this.distribution(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentsByDistribution distribution(@Nullable DCatAPDistributionType dCatAPDistributionType) {
            return this.distribution(dCatAPDistributionType == null ? null : DistributionPojo.builder(dCatAPDistributionType));
        }

        @Nonnull
        public BuilderDocumentsByDistribution distribution(@Nullable DistributionPojo.Builder builder) {
            return this.distribution(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderDocumentsByDistribution distribution(@Nullable DistributionPojo distributionPojo) {
            if (distributionPojo != null) {
                this.m_aDistributions.set(distributionPojo);
            } else {
                this.m_aDistributions.clear();
            }
            return this;
        }

        @Nonnull
        public BuilderDocumentsByDistribution distributions(DistributionPojo ... distributionPojoArray) {
            this.m_aDistributions.setAll((DistributionPojo[])distributionPojoArray);
            return this;
        }

        @Nonnull
        public BuilderDocumentsByDistribution distributions(@Nullable Iterable<? extends DistributionPojo> iterable) {
            this.m_aDistributions.setAll(iterable);
            return this;
        }

        @Nonnull
        public <T> BuilderDocumentsByDistribution distributions(@Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, DistributionPojo> function) {
            this.m_aDistributions.setAllMapped(iterable, function);
            return (BuilderDocumentsByDistribution)this.thisAsT();
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (this.m_aDistributions.isEmpty()) {
                throw new IllegalStateException("A Query Definition of type 'Document' must contain a Distribution");
            }
        }

        @Override
        @Nonnull
        public EDMRequest build() {
            this.checkConsistency();
            return new EDMRequest(this.m_eQueryDefinition, this.m_sRequestID, this.m_eResponseOption, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aProcedure, this.m_aFullfillingRequirements, this.m_aDataConsumer, this.m_sConsentToken, this.m_sDatasetIdentifier, this.m_aDataSubjectLegalPerson, this.m_aDataSubjectNaturalPerson, this.m_aAuthorizedRepresentative, new EDMRequestPayloadDistribution(this.m_aDistributions));
        }
    }

    public static class BuilderConcept
    extends AbstractBuilder<BuilderConcept> {
        private final ICommonsList<ConceptPojo> m_aConcepts = new CommonsArrayList<ConceptPojo>();

        protected BuilderConcept() {
            super(EToopQueryDefinitionType.CONCEPT);
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable Consumer<? super ConceptPojo.Builder> consumer) {
            if (consumer != null) {
                ConceptPojo.Builder builder = ConceptPojo.builder();
                consumer.accept(builder);
                this.addConcept(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable CCCEVConceptType cCCEVConceptType) {
            return this.addConcept(cCCEVConceptType == null ? null : ConceptPojo.builder(cCCEVConceptType));
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable ConceptPojo.Builder builder) {
            return this.addConcept(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderConcept addConcept(@Nullable ConceptPojo conceptPojo) {
            if (conceptPojo != null) {
                this.m_aConcepts.add(conceptPojo);
            }
            return this;
        }

        @Nonnull
        public BuilderConcept concept(@Nullable Consumer<? super ConceptPojo.Builder> consumer) {
            if (consumer != null) {
                ConceptPojo.Builder builder = ConceptPojo.builder();
                consumer.accept(builder);
                this.concept(builder.build());
            }
            return this;
        }

        @Nonnull
        public BuilderConcept concept(@Nullable CCCEVConceptType cCCEVConceptType) {
            return this.concept(cCCEVConceptType == null ? null : ConceptPojo.builder(cCCEVConceptType));
        }

        @Nonnull
        public BuilderConcept concept(@Nullable ConceptPojo.Builder builder) {
            return this.concept(builder == null ? null : builder.build());
        }

        @Nonnull
        public BuilderConcept concept(@Nullable ConceptPojo conceptPojo) {
            if (conceptPojo != null) {
                this.m_aConcepts.set(conceptPojo);
            } else {
                this.m_aConcepts.clear();
            }
            return this;
        }

        @Nonnull
        public BuilderConcept concepts(ConceptPojo ... conceptPojoArray) {
            this.m_aConcepts.setAll((ConceptPojo[])conceptPojoArray);
            return this;
        }

        @Nonnull
        public BuilderConcept concepts(@Nullable Iterable<? extends ConceptPojo> iterable) {
            this.m_aConcepts.setAll(iterable);
            return this;
        }

        @Nonnull
        public <T> BuilderConcept concepts(@Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, ConceptPojo> function) {
            this.m_aConcepts.setAllMapped(iterable, function);
            return (BuilderConcept)this.thisAsT();
        }

        @Override
        public void checkConsistency() {
            super.checkConsistency();
            if (this.m_aConcepts.isEmpty()) {
                throw new IllegalStateException("A Query Definition of type 'Concept' must contain a Concept");
            }
        }

        @Override
        @Nonnull
        public EDMRequest build() {
            this.checkConsistency();
            return new EDMRequest(this.m_eQueryDefinition, this.m_sRequestID, this.m_eResponseOption, this.m_sSpecificationIdentifier, this.m_aIssueDateTime, this.m_aProcedure, this.m_aFullfillingRequirements, this.m_aDataConsumer, this.m_sConsentToken, this.m_sDatasetIdentifier, this.m_aDataSubjectLegalPerson, this.m_aDataSubjectNaturalPerson, this.m_aAuthorizedRepresentative, new EDMRequestPayloadConcepts(this.m_aConcepts));
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    implements IGenericImplTrait<T> {
        protected final EToopQueryDefinitionType m_eQueryDefinition;
        protected String m_sRequestID;
        protected EToopResponseOptionType m_eResponseOption;
        protected String m_sSpecificationIdentifier;
        protected LocalDateTime m_aIssueDateTime;
        protected InternationalStringType m_aProcedure;
        protected final ICommonsList<CCCEVRequirementType> m_aFullfillingRequirements = new CommonsArrayList<CCCEVRequirementType>();
        protected AgentPojo m_aDataConsumer;
        protected String m_sConsentToken;
        protected String m_sDatasetIdentifier;
        protected BusinessPojo m_aDataSubjectLegalPerson;
        protected PersonPojo m_aDataSubjectNaturalPerson;
        protected PersonPojo m_aAuthorizedRepresentative;

        protected AbstractBuilder(@Nonnull EToopQueryDefinitionType eToopQueryDefinitionType) {
            ValueEnforcer.notNull(eToopQueryDefinitionType, "QueryDefinitionType");
            this.m_eQueryDefinition = eToopQueryDefinitionType;
        }

        @Nonnull
        public final T randomID() {
            return this.id(UUID.randomUUID());
        }

        @Nonnull
        public final T id(@Nullable UUID uUID) {
            return this.id(uUID == null ? null : uUID.toString());
        }

        @Nonnull
        public final T id(@Nullable String string) {
            this.m_sRequestID = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T responseOption(@Nullable EToopResponseOptionType eToopResponseOptionType) {
            this.m_eResponseOption = eToopResponseOptionType;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T specificationIdentifier(@Nullable String string) {
            this.m_sSpecificationIdentifier = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T issueDateTimeNow() {
            return this.issueDateTime(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public final T issueDateTime(@Nullable LocalDateTime localDateTime) {
            this.m_aIssueDateTime = localDateTime == null ? null : localDateTime.truncatedTo(ChronoUnit.MILLIS);
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T procedure(LocalizedStringType ... localizedStringTypeArray) {
            return this.procedure(localizedStringTypeArray == null ? null : SlotHelper.createInternationalStringType(localizedStringTypeArray));
        }

        @Nonnull
        public final T procedure(@Nonnull Locale locale, @Nonnull String string) {
            return this.procedure(SlotHelper.createLocalizedString(locale, string));
        }

        @Nonnull
        public final T procedure(@Nonnull @Nonempty String string, @Nonnull String string2) {
            return this.procedure(SlotHelper.createLocalizedString(string, string2));
        }

        @Nonnull
        public final T procedure(@Nonnull EToopLanguageCode eToopLanguageCode, @Nonnull String string) {
            return this.procedure(SlotHelper.createLocalizedString(eToopLanguageCode.getID(), string));
        }

        @Nonnull
        public final T procedure(@Nullable Map<String, String> map) {
            return this.procedure(map == null ? null : SlotHelper.createInternationalStringType(map));
        }

        @Nonnull
        public final T procedure(@Nullable InternationalStringType internationalStringType) {
            this.m_aProcedure = internationalStringType;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T addFullfillingRequirement(@Nullable CCCEVRequirementType cCCEVRequirementType) {
            if (cCCEVRequirementType != null) {
                this.m_aFullfillingRequirements.add(cCCEVRequirementType);
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T fullfillingRequirement(@Nullable CCCEVRequirementType cCCEVRequirementType) {
            if (cCCEVRequirementType != null) {
                this.m_aFullfillingRequirements.set(cCCEVRequirementType);
            } else {
                this.m_aFullfillingRequirements.clear();
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T fullfillingRequirements(CCCEVRequirementType ... cCCEVRequirementTypeArray) {
            this.m_aFullfillingRequirements.setAll((CCCEVRequirementType[])cCCEVRequirementTypeArray);
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T fullfillingRequirements(@Nullable Iterable<? extends CCCEVRequirementType> iterable) {
            this.m_aFullfillingRequirements.setAll(iterable);
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final <U> T fullfillingRequirements(@Nullable Iterable<? extends U> iterable, @Nonnull Function<? super U, CCCEVRequirementType> function) {
            this.m_aFullfillingRequirements.setAllMapped(iterable, function);
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T consentToken(@Nullable String string) {
            this.m_sConsentToken = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T datasetIdentifier(@Nullable String string) {
            this.m_sDatasetIdentifier = string;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataConsumer(@Nullable Consumer<? super AgentPojo.Builder> consumer) {
            if (consumer != null) {
                AgentPojo.Builder builder = AgentPojo.builder();
                consumer.accept(builder);
                this.dataConsumer(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataConsumer(@Nullable AgentType agentType) {
            return this.dataConsumer(agentType == null ? null : AgentPojo.builder(agentType));
        }

        @Nonnull
        public final T dataConsumer(@Nullable AgentPojo.Builder builder) {
            return this.dataConsumer(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T dataConsumer(@Nullable AgentPojo agentPojo) {
            this.m_aDataConsumer = agentPojo;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataSubjectBusiness(@Nullable Consumer<? super BusinessPojo.Builder> consumer) {
            if (consumer != null) {
                BusinessPojo.Builder builder = BusinessPojo.builder();
                consumer.accept(builder);
                this.dataSubject(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataSubject(@Nullable CoreBusinessType coreBusinessType) {
            return this.dataSubject(coreBusinessType == null ? null : BusinessPojo.builder(coreBusinessType));
        }

        @Nonnull
        public final T dataSubject(@Nullable BusinessPojo.Builder builder) {
            return this.dataSubject(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T dataSubject(@Nullable BusinessPojo businessPojo) {
            this.m_aDataSubjectLegalPerson = businessPojo;
            this.m_aDataSubjectNaturalPerson = null;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataSubjectPerson(@Nullable Consumer<? super PersonPojo.Builder> consumer) {
            if (consumer != null) {
                PersonPojo.Builder builder = PersonPojo.builder();
                consumer.accept(builder);
                this.dataSubject(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T dataSubject(@Nullable CorePersonType corePersonType) {
            return this.dataSubject(corePersonType == null ? null : PersonPojo.builder(corePersonType));
        }

        @Nonnull
        public final T dataSubject(@Nullable PersonPojo.Builder builder) {
            return this.dataSubject(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T dataSubject(@Nullable PersonPojo personPojo) {
            this.m_aDataSubjectLegalPerson = null;
            this.m_aDataSubjectNaturalPerson = personPojo;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T authorizedRepresentative(@Nullable Consumer<? super PersonPojo.Builder> consumer) {
            if (consumer != null) {
                PersonPojo.Builder builder = PersonPojo.builder();
                consumer.accept(builder);
                this.authorizedRepresentative(builder.build());
            }
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final T authorizedRepresentative(@Nullable CorePersonType corePersonType) {
            return this.authorizedRepresentative(corePersonType == null ? null : PersonPojo.builder(corePersonType));
        }

        @Nonnull
        public final T authorizedRepresentative(@Nullable PersonPojo.Builder builder) {
            return this.authorizedRepresentative(builder == null ? null : builder.build());
        }

        @Nonnull
        public final T authorizedRepresentative(@Nullable PersonPojo personPojo) {
            this.m_aAuthorizedRepresentative = personPojo;
            return (T)((AbstractBuilder)this.thisAsT());
        }

        @OverridingMethodsMustInvokeSuper
        public void checkConsistency() {
            if (this.m_eQueryDefinition == null) {
                throw new IllegalStateException("Query Definition must be present");
            }
            if (StringHelper.hasNoText(this.m_sRequestID)) {
                throw new IllegalStateException("ID must be present");
            }
            if (this.m_eResponseOption == null) {
                throw new IllegalStateException("Response Option must be present");
            }
            if (StringHelper.hasNoText(this.m_sSpecificationIdentifier)) {
                throw new IllegalStateException("SpecificationIdentifier must be present");
            }
            if (this.m_aIssueDateTime == null) {
                throw new IllegalStateException("Issue Date Time must be present");
            }
            if (this.m_aDataConsumer == null) {
                throw new IllegalStateException("Cata Consumer must be present");
            }
            if (this.m_aDataSubjectLegalPerson == null && this.m_aDataSubjectNaturalPerson == null) {
                throw new IllegalStateException("Data Subject must be present");
            }
            if (this.m_aDataSubjectLegalPerson != null && this.m_aDataSubjectNaturalPerson != null) {
                throw new IllegalStateException("Data Subject MUST be either legal person OR natural person");
            }
        }

        @Nonnull
        public abstract EDMRequest build();
    }
}

