/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.edm.jaxb.cccev.CCCEVConceptType;
import eu.toop.edm.jaxb.cccev.CCCEVValueType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.model.AmountPojo;
import eu.toop.edm.model.ConceptValuePojo;
import eu.toop.edm.model.IConceptName;
import eu.toop.edm.model.MeasurePojo;
import eu.toop.edm.model.PeriodPojo;
import eu.toop.edm.model.QuantityPojo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;

@Immutable
public class ConceptPojo {
    private final String m_sID;
    private final QName m_aName;
    private final ConceptValuePojo m_aValue;
    private final ICommonsList<ConceptPojo> m_aChildren = new CommonsArrayList<ConceptPojo>();

    public ConceptPojo(@Nullable String string, @Nullable QName qName, @Nullable ConceptValuePojo conceptValuePojo, @Nullable List<ConceptPojo> list) {
        this.m_sID = string;
        this.m_aName = qName;
        this.m_aValue = conceptValuePojo;
        if (list != null) {
            this.m_aChildren.addAll(list);
        }
    }

    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    @Nullable
    public final QName getName() {
        return this.m_aName;
    }

    @Nullable
    public final ConceptValuePojo getValue() {
        return this.m_aValue;
    }

    public final boolean hasValue() {
        return this.m_aValue != null;
    }

    public final boolean isErrorValue() {
        return this.m_aValue != null && this.m_aValue.isErrorCodeValue();
    }

    @Nonnull
    @ReturnsMutableObject
    public final List<ConceptPojo> children() {
        return this.m_aChildren;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final List<ConceptPojo> getAllChildren() {
        return (List)this.m_aChildren.getClone();
    }

    private void _visitRecursive(int n, @Nonnull IConceptVisitor iConceptVisitor) {
        iConceptVisitor.onConcept(n, this);
        for (ConceptPojo conceptPojo : this.m_aChildren) {
            conceptPojo._visitRecursive(n + 1, iConceptVisitor);
        }
    }

    public void visitRecursive(@Nonnull IConceptVisitor iConceptVisitor) {
        this._visitRecursive(0, iConceptVisitor);
    }

    @Nonnull
    public Builder getBuilder() {
        return ConceptPojo.builder(this);
    }

    @Nonnull
    public ConceptPojo cloneAndModify(@Nullable Consumer<? super Builder> consumer) {
        return ConceptPojo.builder(this, consumer).build();
    }

    @Nonnull
    public CCCEVConceptType getAsCCCEVConcept() {
        Object object;
        CCCEVConceptType cCCEVConceptType = new CCCEVConceptType();
        if (StringHelper.hasText(this.m_sID)) {
            object = new IDType();
            ((IdentifierType)object).setValue(this.m_sID);
            cCCEVConceptType.addId((IDType)object);
        }
        if (this.m_aName != null) {
            cCCEVConceptType.addQName(this.m_aName);
        }
        if (this.m_aValue != null && (object = this.m_aValue.getAsCCCEVValueType()) != null) {
            cCCEVConceptType.addValue((CCCEVValueType)object);
        }
        for (ConceptPojo conceptPojo : this.m_aChildren) {
            cCCEVConceptType.addConcept(conceptPojo.getAsCCCEVConcept());
        }
        return cCCEVConceptType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ConceptPojo conceptPojo = (ConceptPojo)object;
        return EqualsHelper.equals(this.m_sID, conceptPojo.m_sID) && EqualsHelper.equals(this.m_aName, conceptPojo.m_aName) && EqualsHelper.equals(this.m_aValue, conceptPojo.m_aValue) && EqualsHelper.equals(this.m_aChildren, conceptPojo.m_aChildren);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sID).append(this.m_aName).append(this.m_aValue).append(this.m_aChildren)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("Name", this.m_aName).append("Value", this.m_aValue).append("Children", this.m_aChildren).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable CCCEVConceptType cCCEVConceptType) {
        Builder builder = new Builder();
        if (cCCEVConceptType != null) {
            if (cCCEVConceptType.hasIdEntries()) {
                builder.id(cCCEVConceptType.getIdAtIndex(0).getValue());
            }
            if (cCCEVConceptType.hasQNameEntries()) {
                builder.name(cCCEVConceptType.getQNameAtIndex(0));
            }
            if (cCCEVConceptType.hasValueEntries()) {
                builder.value(ConceptValuePojo.builder(cCCEVConceptType.getValueAtIndex(0)));
            }
            for (CCCEVConceptType cCCEVConceptType2 : cCCEVConceptType.getConcept()) {
                builder.addChild(ConceptPojo.builder(cCCEVConceptType2));
            }
        }
        return builder;
    }

    @Nonnull
    public static Builder builder(@Nullable ConceptPojo conceptPojo) {
        return ConceptPojo.builder(conceptPojo, null);
    }

    @Nonnull
    public static Builder builder(@Nullable ConceptPojo conceptPojo, @Nullable Consumer<? super Builder> consumer) {
        Builder builder = new Builder();
        if (conceptPojo != null) {
            builder.id(conceptPojo.getID()).name(conceptPojo.getName()).value(conceptPojo.getValue());
            for (ConceptPojo conceptPojo2 : conceptPojo.children()) {
                builder.addChild(ConceptPojo.builder(conceptPojo2, consumer));
            }
            if (consumer != null) {
                consumer.accept(builder);
            }
        }
        return builder;
    }

    @NotThreadSafe
    public static class Builder {
        private String m_sID;
        private QName m_aName;
        private ConceptValuePojo m_aValue;
        private final ICommonsList<ConceptPojo> m_aChildren = new CommonsArrayList<ConceptPojo>();

        @Nullable
        public String id() {
            return this.m_sID;
        }

        @Nonnull
        public Builder randomID() {
            return this.id(UUID.randomUUID().toString());
        }

        @Nonnull
        public Builder id(@Nullable String string) {
            this.m_sID = string;
            return this;
        }

        @Nullable
        public QName name() {
            return this.m_aName;
        }

        @Nonnull
        public Builder name(@Nullable String string, @Nullable String string2) {
            return this.name(StringHelper.hasNoText(string2) ? null : new QName(string, string2));
        }

        @Nonnull
        public Builder name(@Nullable IConceptName iConceptName) {
            return this.name(iConceptName == null ? null : iConceptName.getAsQName());
        }

        @Nonnull
        public Builder name(@Nullable QName qName) {
            this.m_aName = qName;
            return this;
        }

        @Nullable
        public ConceptValuePojo value() {
            return this.m_aValue;
        }

        @Nonnull
        public Builder valueID(@Nullable String string) {
            return this.value(ConceptValuePojo.builder().identifier(string));
        }

        @Nonnull
        public Builder valueAmount(@Nullable Consumer<? super AmountPojo.Builder> consumer) {
            return this.value(ConceptValuePojo.builder().amount(consumer));
        }

        @Nonnull
        public Builder valueAmount(@Nullable AmountPojo.Builder builder) {
            return this.value(ConceptValuePojo.builder().amount(builder));
        }

        @Nonnull
        public Builder valueAmount(@Nullable AmountPojo amountPojo) {
            return this.value(ConceptValuePojo.builder().amount(amountPojo));
        }

        @Nonnull
        public Builder valueAmount(@Nullable BigDecimal bigDecimal, @Nullable String string) {
            return this.value(ConceptValuePojo.builder().amount(bigDecimal, string));
        }

        @Nonnull
        public Builder valueCode(@Nullable String string) {
            return this.value(ConceptValuePojo.builder().code(string));
        }

        @Nonnull
        public Builder valueDate(@Nullable LocalDate localDate) {
            return this.value(ConceptValuePojo.builder().date(localDate));
        }

        @Nonnull
        public Builder valueIndicator(boolean bl) {
            return this.value(ConceptValuePojo.builder().indicator(bl));
        }

        @Nonnull
        public Builder valueMeasure(@Nullable Consumer<? super MeasurePojo.Builder> consumer) {
            return this.value(ConceptValuePojo.builder().measure(consumer));
        }

        @Nonnull
        public Builder valueMeasure(@Nullable MeasurePojo.Builder builder) {
            return this.value(ConceptValuePojo.builder().measure(builder));
        }

        @Nonnull
        public Builder valueMeasure(@Nullable MeasurePojo measurePojo) {
            return this.value(ConceptValuePojo.builder().measure(measurePojo));
        }

        @Nonnull
        public Builder valueMeasure(@Nullable BigDecimal bigDecimal, @Nullable String string) {
            return this.value(ConceptValuePojo.builder().measure(bigDecimal, string));
        }

        @Nonnull
        public Builder valuePeriod(@Nullable Consumer<? super PeriodPojo.Builder> consumer) {
            return this.value(ConceptValuePojo.builder().period(consumer));
        }

        @Nonnull
        public Builder valuePeriod(@Nullable PeriodPojo.Builder builder) {
            return this.value(ConceptValuePojo.builder().period(builder));
        }

        @Nonnull
        public Builder valuePeriod(@Nullable PeriodPojo periodPojo) {
            return this.value(ConceptValuePojo.builder().period(periodPojo));
        }

        @Nonnull
        public Builder valuePeriod(@Nullable LocalDateTime localDateTime, @Nullable LocalDateTime localDateTime2) {
            return this.value(ConceptValuePojo.builder().period(localDateTime, localDateTime2));
        }

        @Nonnull
        public Builder valueNumeric(@Nonnull long l) {
            return this.value(ConceptValuePojo.builder().numeric(l));
        }

        @Nonnull
        public Builder valueNumeric(@Nonnull double d) {
            return this.value(ConceptValuePojo.builder().numeric(d));
        }

        @Nonnull
        public Builder valueNumeric(@Nullable BigDecimal bigDecimal) {
            return this.value(ConceptValuePojo.builder().numeric(bigDecimal));
        }

        @Nonnull
        public Builder valueQuantity(@Nullable Consumer<? super QuantityPojo.Builder> consumer) {
            return this.value(ConceptValuePojo.builder().quantity(consumer));
        }

        @Nonnull
        public Builder valueQuantity(@Nullable QuantityPojo.Builder builder) {
            return this.value(ConceptValuePojo.builder().quantity(builder));
        }

        @Nonnull
        public Builder valueQuantity(@Nullable QuantityPojo quantityPojo) {
            return this.value(ConceptValuePojo.builder().quantity(quantityPojo));
        }

        @Nonnull
        public Builder valueQuantity(@Nullable BigDecimal bigDecimal, @Nullable String string) {
            return this.value(ConceptValuePojo.builder().quantity(bigDecimal, string));
        }

        @Nonnull
        public Builder valueText(String ... stringArray) {
            return this.value(ConceptValuePojo.builder().text(stringArray));
        }

        @Nonnull
        public Builder valueTime(@Nullable LocalTime localTime) {
            return this.value(ConceptValuePojo.builder().time(localTime));
        }

        @Nonnull
        public Builder valueURI(@Nonnull String string) {
            return this.value(ConceptValuePojo.builder().uri(string));
        }

        @Nonnull
        public Builder valueErrorCode(@Nullable IToopErrorCode iToopErrorCode) {
            return this.value(ConceptValuePojo.builder().errorCode(iToopErrorCode));
        }

        @Nonnull
        public Builder valueErrorCode(@Nullable String string) {
            return this.value(ConceptValuePojo.builder().errorCode(string));
        }

        @Nonnull
        public Builder value(@Nullable Consumer<? super ConceptValuePojo.Builder> consumer) {
            if (consumer != null) {
                ConceptValuePojo.Builder builder = ConceptValuePojo.builder();
                consumer.accept(builder);
                this.value(builder);
            }
            return this;
        }

        @Nonnull
        public Builder value(@Nullable ConceptValuePojo.Builder builder) {
            return this.value(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder value(@Nullable ConceptValuePojo conceptValuePojo) {
            this.m_aValue = conceptValuePojo;
            return this;
        }

        @Nonnull
        public ICommonsList<ConceptPojo> children() {
            return this.m_aChildren;
        }

        @Nonnull
        public Builder addChild(@Nullable Consumer<? super Builder> consumer) {
            if (consumer != null) {
                Builder builder = ConceptPojo.builder();
                consumer.accept(builder);
                this.addChild(builder);
            }
            return this;
        }

        @Nonnull
        public Builder addChild(@Nullable IConceptName iConceptName) {
            return this.addChild(iConceptName == null ? null : ConceptPojo.builder().name(iConceptName));
        }

        @Nonnull
        public Builder addChild(@Nullable Builder builder) {
            return this.addChild(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder addChild(@Nullable ConceptPojo conceptPojo) {
            if (conceptPojo != null) {
                this.m_aChildren.add(conceptPojo);
            }
            return this;
        }

        @Nonnull
        public Builder child(@Nullable Consumer<? super Builder> consumer) {
            if (consumer != null) {
                Builder builder = ConceptPojo.builder();
                consumer.accept(builder);
                this.child(builder);
            }
            return this;
        }

        @Nonnull
        public Builder child(@Nullable Builder builder) {
            return this.child(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder child(@Nullable ConceptPojo conceptPojo) {
            if (conceptPojo != null) {
                this.m_aChildren.set(conceptPojo);
            } else {
                this.m_aChildren.clear();
            }
            return this;
        }

        @Nonnull
        public Builder children(ConceptPojo ... conceptPojoArray) {
            this.m_aChildren.setAll((ConceptPojo[])conceptPojoArray);
            return this;
        }

        @Nonnull
        public Builder children(@Nullable Iterable<? extends ConceptPojo> iterable) {
            this.m_aChildren.setAll(iterable);
            return this;
        }

        @Nonnull
        public <T> Builder children(@Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, ConceptPojo> function) {
            this.m_aChildren.setAllMapped(iterable, function);
            return this;
        }

        @Nonnull
        public ConceptPojo build() {
            return new ConceptPojo(this.m_sID, this.m_aName, this.m_aValue, this.m_aChildren);
        }
    }

    public static interface IConceptVisitor {
        public void onConcept(@Nonnegative int var1, @Nonnull ConceptPojo var2);
    }
}

