/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.MeasureType;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public class MeasurePojo {
    private final BigDecimal m_aValue;
    private final String m_sUnitCode;

    public MeasurePojo(@Nullable BigDecimal bigDecimal, @Nullable String string) {
        this.m_aValue = bigDecimal;
        this.m_sUnitCode = string;
    }

    @Nullable
    public final BigDecimal getValue() {
        return this.m_aValue;
    }

    @Nullable
    public final String getUnitCode() {
        return this.m_sUnitCode;
    }

    @Nonnull
    public MeasureType getAsMeasure() {
        MeasureType measureType = new MeasureType();
        measureType.setValue(this.m_aValue);
        measureType.setUnitCode(this.m_sUnitCode);
        return measureType;
    }

    @Nullable
    public String getAsString() {
        if (this.m_aValue != null) {
            if (this.m_sUnitCode != null) {
                return this.m_aValue.toString() + " " + this.m_sUnitCode;
            }
            return this.m_aValue.toString();
        }
        return this.m_sUnitCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MeasurePojo measurePojo = (MeasurePojo)object;
        return EqualsHelper.equals(this.m_aValue, measurePojo.m_aValue) && EqualsHelper.equals(this.m_sUnitCode, measurePojo.m_sUnitCode);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).append(this.m_sUnitCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Value", this.m_aValue).append("UnitCode", this.m_sUnitCode).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable MeasureType measureType) {
        Builder builder = new Builder();
        if (measureType != null) {
            builder.value(measureType.getValue()).unitCode(measureType.getUnitCode());
        }
        return builder;
    }

    @NotThreadSafe
    public static class Builder {
        private BigDecimal m_aValue;
        private String m_sUnitCode;

        public Builder value(@Nonnull long l) {
            return this.value(MathHelper.toBigDecimal(l));
        }

        @Nonnull
        public Builder value(@Nonnull double d) {
            return this.value(MathHelper.toBigDecimal(d));
        }

        @Nonnull
        public Builder value(@Nullable BigDecimal bigDecimal) {
            this.m_aValue = bigDecimal;
            return this;
        }

        @Nonnull
        public Builder unitCode(@Nullable String string) {
            this.m_sUnitCode = string;
            return this;
        }

        @Nonnull
        public MeasurePojo build() {
            return new MeasurePojo(this.m_aValue, this.m_sUnitCode);
        }
    }
}

